/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.AllTrainIcons;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.trains.entity.TrainIcon;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractStationScreen
extends AbstractSimiScreen {
    protected AllGuiTextures background;
    protected StationBlockEntity blockEntity;
    protected GlobalStation station;
    private ElementWidget renderedItem;
    private ElementWidget renderedFlag;
    protected WeakReference<Train> displayedTrain;
    private IconButton confirmButton;

    public AbstractStationScreen(StationBlockEntity be, GlobalStation station) {
        super((Component)be.getBlockState().getBlock().getName());
        this.blockEntity = be;
        this.station = station;
        this.displayedTrain = new WeakReference<Object>(null);
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.init();
        this.clearWidgets();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::onClose);
        this.addRenderableWidget(this.confirmButton);
        this.renderedFlag = new ElementWidget(x + this.background.getWidth() + 25, y + this.background.getHeight() - 62).showingElement(GuiGameElement.partial().scale(2.5f).transform(this::transform).padding(13));
        this.addRenderableWidget(this.renderedFlag);
        this.renderedItem = new ElementWidget(x + this.background.getWidth() + 3, y + this.background.getHeight() - 46).showingElement(GuiGameElement.of((BlockState)this.blockEntity.getBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).rotate(-22.0f, 63.0f, 0.0f).scale(2.5f).padding(17));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    public int getTrainIconWidth(Train train) {
        TrainIcon icon = AllTrainIcons.byType(train.icon);
        List<Carriage> carriages = train.carriages;
        int w = icon.getIconWidth(-1);
        if (carriages.size() == 1) {
            return w;
        }
        for (int i = 1; i < carriages.size(); ++i) {
            if (i == carriages.size() - 1 && train.doubleEnded) {
                w += icon.getIconWidth(-2) + 1;
                break;
            }
            Carriage carriage = carriages.get(i);
            w += icon.getIconWidth(carriage.bogeySpacing) + 1;
        }
        return w;
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        GuiGameElement.GuiPartialRenderBuilder flag = (GuiGameElement.GuiPartialRenderBuilder)this.renderedFlag.getRenderElement();
        if (this.blockEntity.resolveFlagAngle()) {
            flag.partial(this.getFlag(partialTicks)).tick(this.blockEntity.flag.settled() ? 1.0f : partialTicks);
        } else {
            flag.partial(null);
        }
    }

    private void transform(PoseStack ms, float partialTicks) {
        ms.scale(1.0f, -1.0f, 1.0f);
        float value = this.blockEntity.flag.getValue(partialTicks);
        float progress = (float)Math.pow(Math.min(value * 5.0f, 1.0f), 2.0);
        if (this.blockEntity.flag.getChaseTarget() > 0.0f && !this.blockEntity.flag.settled() && progress == 1.0f) {
            float wiggleProgress = (value - 0.2f) / 0.8f;
            progress = (float)((double)progress + Math.sin(wiggleProgress * ((float)Math.PI * 2) * 4.0f) / 8.0 / (double)Math.max(1.0f, 8.0f * wiggleProgress));
        }
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateXDegrees(24.0f)).rotateYDegrees(-210.0f)).translate(-0.12f, -0.81f, 0.0f).rotateYDegrees(90.0f)).rotateXDegrees(progress * 90.0f + 270.0f);
    }

    protected abstract PartialModel getFlag(float var1);

    protected Train getImminent() {
        return this.blockEntity.imminentTrain == null ? null : Create.RAILWAYS.trains.get(this.blockEntity.imminentTrain);
    }

    protected boolean trainPresent() {
        return this.blockEntity.trainPresent;
    }
}

