/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.trains.station.AbstractStationScreen;
import com.zurrtum.create.client.content.trains.station.StationScreen;
import com.zurrtum.create.client.content.trains.station.WideIconButton;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.StationEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainEditPacket;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;

public class AssemblyScreen
extends AbstractStationScreen {
    private IconButton quitAssembly;
    private IconButton toggleAssemblyButton;
    private List<Identifier> iconTypes;
    private ScrollInput iconTypeScroll;

    public AssemblyScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION_ASSEMBLING;
    }

    @Override
    protected void init() {
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        int by = y + this.background.getHeight() - 24;
        Renderable widget = (Renderable)this.renderables.getFirst();
        if (widget instanceof IconButton) {
            IconButton ib = (IconButton)widget;
            ib.setIcon(AllIcons.I_PRIORITY_VERY_LOW);
            ib.setToolTip((Component)CreateLang.translateDirect("station.close", new Object[0]));
        }
        this.iconTypes = TrainIconType.ALL.keySet().stream().toList();
        this.iconTypeScroll = new ScrollInput(x + 4, y + 17, 162, 14).titled(CreateLang.translateDirect("station.icon_type", new Object[0]));
        this.iconTypeScroll.withRange(0, this.iconTypes.size());
        this.iconTypeScroll.withStepFunction(ctx -> -this.iconTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx).intValue());
        this.iconTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.icon = TrainIconType.byId(this.iconTypes.get((int)s));
            }
        });
        this.iconTypeScroll.visible = false;
        this.iconTypeScroll.active = false;
        this.addRenderableWidget(this.iconTypeScroll);
        this.toggleAssemblyButton = new WideIconButton(x + 94, by, AllGuiTextures.I_ASSEMBLE_TRAIN);
        this.toggleAssemblyButton.active = false;
        this.toggleAssemblyButton.setToolTip((Component)CreateLang.translateDirect("station.assemble_train", new Object[0]));
        this.toggleAssemblyButton.withCallback(() -> this.minecraft.player.connection.send((Packet)StationEditPacket.tryAssemble(this.blockEntity.getBlockPos())));
        this.quitAssembly = new IconButton(x + 73, by, AllIcons.I_DISABLE);
        this.quitAssembly.active = true;
        this.quitAssembly.setToolTip((Component)CreateLang.translateDirect("station.cancel", new Object[0]));
        this.quitAssembly.withCallback(() -> {
            this.minecraft.player.connection.send((Packet)StationEditPacket.configure(this.blockEntity.getBlockPos(), false, this.station.name, null));
            this.minecraft.setScreen((Screen)new StationScreen(this.blockEntity, this.station));
        });
        this.addRenderableWidget(this.toggleAssemblyButton);
        this.addRenderableWidget(this.quitAssembly);
        this.tickTrainDisplay();
    }

    @Override
    public void tick() {
        super.tick();
        this.tickTrainDisplay();
        Train train = (Train)this.displayedTrain.get();
        boolean bl = this.toggleAssemblyButton.active = this.blockEntity.bogeyCount > 0 || train != null;
        if (train != null) {
            this.minecraft.player.connection.send((Packet)StationEditPacket.configure(this.blockEntity.getBlockPos(), false, this.station.name, null));
            this.minecraft.setScreen((Screen)new StationScreen(this.blockEntity, this.station));
            for (Carriage carriage : train.carriages) {
                carriage.updateConductors();
            }
        }
    }

    private void tickTrainDisplay() {
        if (this.getImminent() == null) {
            this.displayedTrain = new WeakReference<Object>(null);
            this.quitAssembly.active = true;
            this.iconTypeScroll.visible = false;
            this.iconTypeScroll.active = false;
            this.toggleAssemblyButton.setToolTip((Component)CreateLang.translateDirect("station.assemble_train", new Object[0]));
            this.toggleAssemblyButton.setIcon(AllGuiTextures.I_ASSEMBLE_TRAIN);
            this.toggleAssemblyButton.withCallback(() -> this.minecraft.player.connection.send((Packet)StationEditPacket.tryAssemble(this.blockEntity.getBlockPos())));
        } else {
            this.minecraft.player.connection.send((Packet)StationEditPacket.configure(this.blockEntity.getBlockPos(), false, this.station.name, null));
            this.minecraft.setScreen((Screen)new StationScreen(this.blockEntity, this.station));
        }
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        MutableComponent header = CreateLang.translateDirect("station.assembly_title", new Object[0]);
        graphics.drawString(this.font, (Component)header, x + this.background.getWidth() / 2 - this.font.width((FormattedText)header) / 2, y + 4, -15850957, false);
        AssemblyException lastAssemblyException = this.blockEntity.lastException;
        if (lastAssemblyException != null) {
            MutableComponent text = CreateLang.translateDirect("station.failed", new Object[0]);
            graphics.drawString(this.font, (Component)text, x + 97 - this.font.width((FormattedText)text) / 2, y + 47, -8955045, false);
            int offset = 0;
            if (this.blockEntity.failedCarriageIndex != -1) {
                graphics.drawString(this.font, (Component)CreateLang.translateDirect("station.carriage_number", this.blockEntity.failedCarriageIndex), x + 30, y + 67, -8750470, false);
                offset += 10;
            }
            graphics.drawWordWrap(this.font, (FormattedText)lastAssemblyException.component, x + 30, y + 67 + offset, 134, -8955045, false);
            graphics.drawWordWrap(this.font, (FormattedText)CreateLang.translateDirect("station.retry", new Object[0]), x + 30, y + 67 + (offset += this.font.split((FormattedText)lastAssemblyException.component, 134).size() * 9 + 5), 134, -8750470, false);
            return;
        }
        int bogeyCount = this.blockEntity.bogeyCount;
        MutableComponent text = CreateLang.translateDirect(bogeyCount == 0 ? "station.no_bogeys" : (bogeyCount == 1 ? "station.one_bogey" : "station.more_bogeys"), bogeyCount);
        graphics.drawString(this.font, (Component)text, x + 97 - this.font.width((FormattedText)text) / 2, y + 47, -8750470, false);
        graphics.drawWordWrap(this.font, (FormattedText)CreateLang.translateDirect("station.how_to", new Object[0]), x + 28, y + 62, 134, -8750470, false);
        graphics.drawWordWrap(this.font, (FormattedText)CreateLang.translateDirect("station.how_to_1", new Object[0]), x + 28, y + 94, 134, -8750470, false);
        graphics.drawWordWrap(this.font, (FormattedText)CreateLang.translateDirect("station.how_to_2", new Object[0]), x + 28, y + 117, 138, -8750470, false);
    }

    public void removed() {
        super.removed();
        Train train = (Train)this.displayedTrain.get();
        if (train != null) {
            Identifier iconId = this.iconTypes.get(this.iconTypeScroll.getState());
            train.icon = TrainIconType.byId(iconId);
            this.minecraft.player.connection.send((Packet)new TrainEditPacket(train.id, "", iconId, train.mapColorIndex));
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return AllPartialModels.STATION_ASSEMBLE;
    }
}

