/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import java.util.List;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StationRenderer
implements BlockEntityRenderer<StationBlockEntity, StationRenderState> {
    protected final ItemModelResolver itemModelManager;

    public StationRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public StationRenderState createRenderState() {
        return new StationRenderState();
    }

    public void extractRenderState(StationBlockEntity be, StationRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        TrackBlockRenderer renderer;
        state.blockPos = be.getBlockPos();
        state.blockEntityType = be.getType();
        Level world = be.getLevel();
        state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
        DepotBehaviour depotBehaviour = be.depotBehaviour;
        state.incoming = DepotRenderer.createIncomingStateList(depotBehaviour, this.itemModelManager, tickProgress, world);
        state.outputs = DepotRenderer.createOutputStateList(depotBehaviour, this.itemModelManager, world);
        TrackTargetingBehaviour<GlobalStation> target = be.edgePoint;
        BlockPos targetPosition = target.getGlobalPosition();
        BlockState trackState = world.getBlockState(targetPosition);
        Block block = trackState.getBlock();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        GlobalStation station = be.getStation();
        boolean isAssembling = (Boolean)be.getBlockState().getValue((Property)StationBlock.ASSEMBLING);
        if (!isAssembling || (station == null || station.getPresentTrain() != null) && !be.isVirtual()) {
            this.updateFlagState(be.flag.getValue(tickProgress) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF, be, state, tickProgress);
            TrackBlockRenderer renderer2 = AllTrackRenders.get(track);
            if (renderer2 != null) {
                state.block = renderer2.getRenderState(world, new Vec3((double)(targetPosition.getX() - state.blockPos.getX()), (double)(targetPosition.getY() - state.blockPos.getY()), (double)(targetPosition.getZ() - state.blockPos.getZ())), trackState, targetPosition, target.getTargetDirection(), target.getTargetBezier(), TrackTargetingBehaviour.RenderedTrackOverlayType.STATION, 1.0f);
            }
            return;
        }
        this.updateFlagState(AllPartialModels.STATION_ASSEMBLE, be, state, tickProgress);
        if (be.isVirtual() && be.bogeyLocations == null) {
            be.refreshAssemblyInfo();
        }
        if ((renderer = AllTrackRenders.get(track)) == null) {
            return;
        }
        state.block = renderer.getAssemblyRenderState(be, new Vec3((double)(targetPosition.getX() - state.blockPos.getX()), (double)(targetPosition.getY() - state.blockPos.getY()), (double)(targetPosition.getZ() - state.blockPos.getZ())), world, targetPosition, trackState);
    }

    public void updateFlagState(PartialModel flag, StationBlockEntity be, StationRenderState state, float tickProgress) {
        if (be.resolveFlagAngle()) {
            state.layer = RenderTypes.cutoutMovingBlock();
            state.flag = CachedBuffers.partial(flag, be.getBlockState());
            float value = be.flag.getValue(tickProgress);
            float progress = (float)Math.pow(Math.min(value * 5.0f, 1.0f), 2.0);
            if (be.flag.getChaseTarget() > 0.0f && !be.flag.settled() && progress == 1.0f) {
                float wiggleProgress = (value - 0.2f) / 0.8f;
                progress += (float)(Math.sin(wiggleProgress * ((float)Math.PI * 2) * 4.0f) / 8.0 / (double)Math.max(1.0f, 8.0f * wiggleProgress));
            }
            float nudge = 0.001953125f;
            state.flagYRot = (float)Math.PI / 180 * (float)be.flagYRot;
            boolean flipped = be.flagFlipped;
            state.flagOffsetZ = flipped ? 0.875f - nudge : 0.125f + nudge;
            state.flagXRot = (float)Math.PI / 180 * (float)(flipped ? 1 : -1) * (progress * 90.0f + 270.0f);
            state.flagYRot2 = flipped ? 0.0f : (float)Math.PI;
        }
    }

    public void submit(StationRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.incoming != null || state.outputs != null) {
            DepotRenderer.renderItemsOf(state.incoming, state.outputs, state.blockPos, cameraState.pos, queue, matrices, state.lightCoords);
        }
        if (state.layer != null) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
        if (state.block != null) {
            state.block.render(matrices, queue);
        }
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 192;
    }

    public static class StationRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public DepotRenderer.DepotItemState[] incoming;
        public List<DepotRenderer.DepotOutputItemState> outputs;
        public RenderType layer;
        public SuperByteBuffer flag;
        public float flagYRot;
        public float flagOffsetZ;
        public float flagXRot;
        public float flagYRot2;
        public TrackBlockRenderState block;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.flag != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.flag.center()).rotateY(this.flagYRot)).translate(0.001953125f, 0.59375f, this.flagOffsetZ)).uncenter();
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.flag.rotateX(this.flagXRot)).translate(0.03125f, 0.0f, 0.0f)).rotateY(this.flagYRot2)).translate(-0.03125f, 0.0f, 0.0f);
                this.flag.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

