/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.content.trains.track.TrackRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Affine;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackShape;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class StandardTrackBlockRenderer
implements TrackBlockRenderer {
    @Override
    public <Self extends Affine<Self>> void prepareTrackOverlay(Affine<Self> affine, BlockGetter world, BlockPos pos, BlockState state, BezierTrackPointLocation bezierPoint, Direction.AxisDirection direction, TrackTargetingBehaviour.RenderedTrackOverlayType type) {
        TrackBlockEntity trackTE;
        BlockEntity length2;
        BlockEntity blockEntity;
        Vec3 axis = null;
        Vec3 diff = null;
        Vec3 normal = null;
        if (bezierPoint != null && (blockEntity = world.getBlockEntity(pos)) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
            BezierConnection bc = trackBE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                double length2 = Mth.floor((double)(bc.getLength() * 2.0));
                int seg = bezierPoint.segment() + 1;
                double t = (double)seg / length2;
                double tpre = (double)(seg - 1) / length2;
                double tpost = (double)(seg + 1) / length2;
                Vec3 offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).subtract(bc.getPosition(tpre)).normalize();
                affine.translate(offset.subtract(Vec3.atBottomCenterOf((Vec3i)pos)));
                affine.translate(0.0f, -0.25f, 0.0f);
            } else {
                return;
            }
        }
        if (normal == null) {
            axis = ((TrackShape)((Object)state.getValue(TrackBlock.SHAPE))).getAxes().get(0);
            diff = axis.scale((double)direction.getStep()).normalize();
            normal = ((TrackShape)((Object)state.getValue(TrackBlock.SHAPE))).getNormal();
        }
        Vec3 angles = TrackRenderer.getModelAngles(normal, diff);
        ((Affine)((Affine)((Affine)affine.center()).rotateY((float)angles.y)).rotateX((float)angles.x)).uncenter();
        if (axis != null) {
            affine.translate(0.0f, axis.y != 0.0 ? 0.4375f : 0.0f, axis.y != 0.0 ? (float)direction.getStep() * 2.5f / 16.0f : 0.0f);
        } else {
            affine.translate(0.0f, 0.25f, 0.0f);
            if (direction == Direction.AxisDirection.NEGATIVE) {
                affine.rotateCentered((float)Math.PI, Direction.UP);
            }
        }
        if (bezierPoint == null && (length2 = world.getBlockEntity(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)length2).isTilted()) {
            double yOffset = 0.0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += ((Vec3)bc.starts.getFirst()).y - (double)pos.getY();
            }
            ((Affine)((Affine)((Affine)affine.center()).rotateXDegrees((float)((double)(-direction.getStep()) * trackTE.tilt.smoothingAngle.get()))).uncenter()).translate(0.0, yOffset / 2.0, 0.0);
        }
    }

    @Override
    public TrackBlockRenderState getRenderState(Level world, Vec3 offset, BlockState trackState, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, TrackTargetingBehaviour.RenderedTrackOverlayType type, float scale) {
        TrackBlockEntity trackTE;
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (world instanceof SchematicLevel && !(world instanceof PonderLevel)) {
            return null;
        }
        Vec3 axis = null;
        Vec3 diff = null;
        Vec3 normal = null;
        if (bezier != null && (blockEntity2 = world.getBlockEntity(pos)) instanceof TrackBlockEntity) {
            TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity2;
            BezierConnection bc = trackBE.getConnections().get(bezier.curveTarget());
            if (bc != null) {
                double length = Mth.floor((double)(bc.getLength() * 2.0));
                int seg = bezier.segment() + 1;
                double t = (double)seg / length;
                double tpre = (double)(seg - 1) / length;
                double tpost = (double)(seg + 1) / length;
                offset = bc.getPosition(t).subtract(Vec3.atBottomCenterOf((Vec3i)pos)).add(offset).add(0.0, -0.25, 0.0);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).subtract(bc.getPosition(tpre)).normalize();
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = ((TrackShape)((Object)trackState.getValue(TrackBlock.SHAPE))).getAxes().getFirst();
            diff = axis.scale((double)direction.getStep()).normalize();
            normal = ((TrackShape)((Object)trackState.getValue(TrackBlock.SHAPE))).getNormal();
        }
        StandardTrackBlockRenderState state = new StandardTrackBlockRenderState();
        state.offset = offset;
        Vec3 angles = TrackRenderer.getModelAngles(normal, diff);
        state.yRot = (float)angles.y;
        state.xRot = (float)angles.x;
        if (axis != null) {
            state.offset2 = axis.y != 0.0 ? new Vec3(0.0, 0.4375, (double)((float)direction.getStep() * 2.5f / 16.0f)) : Vec3.ZERO;
        } else if (direction == Direction.AxisDirection.NEGATIVE) {
            state.negative = true;
        }
        if (bezier == null && (blockEntity = world.getBlockEntity(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)blockEntity).isTilted()) {
            double yOffset = 0.0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += ((Vec3)bc.starts.getFirst()).y - (double)pos.getY();
            }
            state.xRot2 = (float)Math.PI / 180 * (float)((double)(-direction.getStep()) * trackTE.tilt.smoothingAngle.get());
            state.offset3 = Float.valueOf((float)(yOffset / 2.0));
        }
        state.layer = RenderTypes.cutoutMovingBlock();
        PartialModel partial = switch (type) {
            default -> throw new MatchException(null, null);
            case TrackTargetingBehaviour.RenderedTrackOverlayType.DUAL_SIGNAL -> AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER -> AllPartialModels.TRACK_OBSERVER_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.SIGNAL -> AllPartialModels.TRACK_SIGNAL_OVERLAY;
            case TrackTargetingBehaviour.RenderedTrackOverlayType.STATION -> AllPartialModels.TRACK_STATION_OVERLAY;
        };
        state.model = CachedBuffers.partial(partial, trackState);
        state.scale = scale;
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)pos);
        return state;
    }

    @Override
    public TrackBlockRenderState getAssemblyRenderState(StationBlockEntity be, Vec3 offset, Level world, BlockPos pos, BlockState blockState) {
        Direction direction = be.assemblyDirection;
        if (direction == null) {
            return null;
        }
        int length = be.assemblyLength;
        if (length == 0) {
            return null;
        }
        int[] locations = be.bogeyLocations;
        if (locations == null) {
            return null;
        }
        StandardTrackAssemblyRenderState state = new StandardTrackAssemblyRenderState();
        state.layer = RenderTypes.cutoutMovingBlock();
        state.offset = offset;
        state.angle = AngleHelper.rad(AngleHelper.horizontalAngle(direction));
        state.model = CachedBuffers.partial(AllPartialModels.TRACK_ASSEMBLING_OVERLAY, blockState);
        int colorWhenValid = 9876991;
        int colorWhenCarriage = 13303702;
        BlockPos.MutableBlockPos currentPos = pos.mutable();
        int[][] nArrayArray = new int[length][];
        state.data = nArrayArray;
        int[][] data = nArrayArray;
        int index = 0;
        for (int location : locations) {
            if (location == -1) break;
            int i = index;
            index = location;
            while (i < index) {
                if (be.isValidBogeyOffset(i)) {
                    data[i] = new int[]{colorWhenValid, LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)currentPos.move(direction, 1))};
                }
                ++i;
            }
            data[i] = new int[]{colorWhenCarriage, LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)currentPos.move(direction, 1))};
            ++index;
        }
        while (index < length) {
            if (be.isValidBogeyOffset(index)) {
                data[index] = new int[]{colorWhenValid, LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)currentPos.move(direction, 1))};
            }
            ++index;
        }
        return state;
    }

    public static class StandardTrackBlockRenderState
    extends TrackBlockRenderState {
        public Vec3 offset;
        public float yRot;
        public float xRot;
        public Vec3 offset2;
        public float xRot2;
        public Float offset3;
        public boolean negative;
        public SuperByteBuffer model;
        public int light;
        public float scale;

        @Override
        public void transform(PoseStack matrices) {
            matrices.translate(this.offset);
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.xRot));
            matrices.translate(-0.5f, -0.5f, -0.5f);
            if (this.offset2 != null) {
                if (this.offset2 != Vec3.ZERO) {
                    matrices.translate(this.offset2);
                }
            } else {
                matrices.translate(0.0f, 0.25f, 0.0f);
                if (this.negative) {
                    matrices.rotateAround((Quaternionfc)new Quaternionf().setAngleAxis(Math.PI, 0.0, 1.0, 0.0), 0.5f, 0.5f, 0.5f);
                }
            }
            if (this.offset3 != null) {
                matrices.translate(0.5f, 0.5f, 0.5f);
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.xRot2));
                matrices.translate(-0.5f, -0.5f, -0.5f);
                matrices.translate(0.0f, this.offset3.floatValue(), 0.0f);
            }
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.translate(0.5f, 0.0f, 0.5f)).scale(this.scale)).translate(-0.5f, 0.0f, -0.5f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static class StandardTrackAssemblyRenderState
    extends TrackBlockRenderState {
        public Vec3 offset;
        public float angle;
        public SuperByteBuffer model;
        public int[][] data;

        @Override
        public void transform(PoseStack matrices) {
            matrices.translate(this.offset);
            matrices.rotateAround((Quaternionfc)new Quaternionf().setAngleAxis(this.angle, 0.0f, 1.0f, 0.0f), 0.5f, 0.5f, 0.5f);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (int[] pair : this.data) {
                matricesEntry.translate(0.0f, 0.0f, 1.0f);
                if (pair == null) continue;
                this.model.color(pair[0]).light(pair[1]).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

