/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockItem;
import com.zurrtum.create.content.trains.track.TrackPlacement;
import com.zurrtum.create.infrastructure.packet.c2s.PlaceExtendedCurvePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TrackPlacementClient {
    static LerpedFloat animation = LerpedFloat.linear().startWithValue(0.0);
    static int lastLineCount = 0;
    static BlockPos hintPos;
    static int hintAngle;
    static Couple<List<BlockPos>> hints;
    static int extraTipWarmup;

    public static void clientTick(Minecraft mc) {
        int i;
        BlockHitResult bhr;
        BlockPos pos;
        LocalPlayer player = mc.player;
        ItemStack stack = player.getMainHandItem();
        HitResult hitResult = mc.hitResult;
        int restoreWarmup = extraTipWarmup;
        extraTipWarmup = 0;
        if (hitResult == null) {
            return;
        }
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!stack.is(AllItemTags.TRACKS)) {
            stack = player.getOffhandItem();
            hand = InteractionHand.OFF_HAND;
            if (!stack.is(AllItemTags.TRACKS)) {
                return;
            }
        }
        if (!stack.hasFoil()) {
            return;
        }
        TrackBlockItem blockItem = (TrackBlockItem)stack.getItem();
        Level level = player.level();
        BlockState hitState = level.getBlockState(pos = (bhr = (BlockHitResult)hitResult).getBlockPos());
        if (!(hitState.getBlock() instanceof TrackBlock) && !hitState.canBeReplaced()) {
            pos = pos.relative(bhr.getDirection());
            hitState = blockItem.getPlacementState(new UseOnContext((Player)player, hand, bhr));
            if (hitState == null) {
                return;
            }
        }
        if (!(hitState.getBlock() instanceof TrackBlock)) {
            return;
        }
        extraTipWarmup = restoreWarmup;
        boolean maxTurns = mc.options.keySprint.isDown();
        TrackPlacement.PlacementInfo info = TrackPlacement.tryConnect(level, (Player)player, pos, hitState, stack, false, maxTurns);
        if (extraTipWarmup < 20) {
            ++extraTipWarmup;
        }
        if (!info.valid || !TrackPlacement.hoveringMaxed && (info.end1Extent == 0 || info.end2Extent == 0)) {
            extraTipWarmup = 0;
        }
        if (!(player.isCreative() || !info.valid && info.hasRequiredTracks && info.hasRequiredPavement)) {
            BlueprintOverlayRenderer.displayTrackRequirements(info, player.getOffhandItem());
        }
        if (info.valid) {
            player.displayClientMessage((Component)CreateLang.translateDirect("track.valid_connection", new Object[0]).withStyle(ChatFormatting.GREEN), true);
        } else if (info.message != null) {
            player.displayClientMessage((Component)CreateLang.translateDirect(info.message, new Object[0]).withStyle(info.message.equals("track.second_point") ? ChatFormatting.WHITE : ChatFormatting.RED), true);
        }
        if (bhr.getDirection() == Direction.UP) {
            Vec3 lookVec = player.getLookAngle();
            int lookAngle = (int)(22.5 + (double)(AngleHelper.deg(Mth.atan2((double)lookVec.z, (double)lookVec.x)) % 360.0f)) / 8;
            if (!pos.equals((Object)hintPos) || lookAngle != hintAngle) {
                hints = Couple.create(ArrayList::new);
                hintAngle = lookAngle;
                hintPos = pos;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        BlockPos offset = pos.offset(xOffset, 0, zOffset);
                        TrackPlacement.PlacementInfo adjInfo = TrackPlacement.tryConnect(level, (Player)player, offset, hitState, stack, false, maxTurns);
                        hints.get(adjInfo.valid).add(offset.below());
                    }
                }
            }
            if (hints != null && !hints.either(Collection::isEmpty)) {
                Outliner.getInstance().showCluster("track_valid", (Iterable)hints.getFirst()).withFaceTexture(AllSpecialTextures.THIN_CHECKERED).colored(9817409).lineWidth(0.0f);
                Outliner.getInstance().showCluster("track_invalid", (Iterable)hints.getSecond()).withFaceTexture(AllSpecialTextures.THIN_CHECKERED).colored(15359019).lineWidth(0.0f);
            }
        }
        animation.chase(info.valid ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.EXP);
        animation.tickChaser();
        if (!info.valid) {
            info.end1Extent = 0;
            info.end2Extent = 0;
        }
        int color = Color.mixColors(15359019, 9817409, animation.getValue());
        Vec3 up = new Vec3(0.0, 0.25, 0.0);
        Vec3 v1 = info.end1;
        Vec3 a1 = info.axis1.normalize();
        Vec3 n1 = info.normal1.cross(a1).scale(0.9375);
        Vec3 o1 = a1.scale(0.125);
        Vec3 ex1 = a1.scale((double)(info.end1Extent - (info.curve == null && info.end1Extent > 0 ? 2 : 0)) * info.axis1.length());
        TrackPlacementClient.line(1, v1.add(n1).add(up), o1, ex1);
        TrackPlacementClient.line(2, v1.subtract(n1).add(up), o1, ex1);
        Vec3 v2 = info.end2;
        Vec3 a2 = info.axis2.normalize();
        Vec3 n2 = info.normal2.cross(a2).scale(0.9375);
        Vec3 o2 = a2.scale(0.125);
        Vec3 ex2 = a2.scale((double)info.end2Extent * info.axis2.length());
        TrackPlacementClient.line(3, v2.add(n2).add(up), o2, ex2);
        TrackPlacementClient.line(4, v2.subtract(n2).add(up), o2, ex2);
        BezierConnection bc = info.curve;
        if (bc == null) {
            return;
        }
        Vec3 previous1 = null;
        Vec3 previous2 = null;
        int railcolor = color;
        int segCount = bc.getSegmentCount();
        float s = animation.getValue() * 7.0f / 8.0f + 0.125f;
        float lw = animation.getValue() * 1.0f / 16.0f + 0.0625f;
        Vec3 end1 = (Vec3)bc.starts.getFirst();
        Vec3 end2 = (Vec3)bc.starts.getSecond();
        Vec3 finish1 = end1.add(((Vec3)bc.axes.getFirst()).scale(bc.getHandleLength()));
        Vec3 finish2 = end2.add(((Vec3)bc.axes.getSecond()).scale(bc.getHandleLength()));
        String key = "curve";
        for (i = 0; i <= segCount; ++i) {
            float t = (float)i / (float)segCount;
            Vec3 result = VecHelper.bezier(end1, end2, finish1, finish2, t);
            Vec3 derivative = VecHelper.bezierDerivative(end1, end2, finish1, finish2, t).normalize();
            Vec3 normal = bc.getNormal(t).cross(derivative).scale(0.9375);
            Vec3 rail1 = result.add(normal).add(up);
            Vec3 rail2 = result.subtract(normal).add(up);
            if (previous1 != null) {
                Vec3 middle1 = rail1.add(previous1).scale(0.5);
                Vec3 middle2 = rail2.add(previous2).scale(0.5);
                Outliner.getInstance().showLine(Pair.of(key, i * 2), VecHelper.lerp(s, middle1, previous1), VecHelper.lerp(s, middle1, rail1)).colored(railcolor).disableLineNormals().lineWidth(lw);
                Outliner.getInstance().showLine(Pair.of(key, i * 2 + 1), VecHelper.lerp(s, middle2, previous2), VecHelper.lerp(s, middle2, rail2)).colored(railcolor).disableLineNormals().lineWidth(lw);
            }
            previous1 = rail1;
            previous2 = rail2;
        }
        for (i = segCount + 1; i <= lastLineCount; ++i) {
            Outliner.getInstance().remove(Pair.of(key, i * 2));
            Outliner.getInstance().remove(Pair.of(key, i * 2 + 1));
        }
        lastLineCount = segCount;
    }

    private static void line(int id, Vec3 v1, Vec3 o1, Vec3 ex) {
        int color = Color.mixColors(15359019, 9817409, animation.getValue());
        Outliner.getInstance().showLine(Pair.of("start", id), v1.subtract(o1), v1.add(ex)).lineWidth(0.125f).disableLineNormals().colored(color);
    }

    public static InteractionResult sendExtenderPacket(LocalPlayer player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.is(AllItemTags.TRACKS)) {
            return null;
        }
        if (Minecraft.getInstance().options.keySprint.isDown()) {
            player.connection.send((Packet)new PlaceExtendedCurvePacket(hand == InteractionHand.MAIN_HAND, true));
            return InteractionResult.SUCCESS;
        }
        return null;
    }
}

