/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.track;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackMaterialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class TrackRenderer
implements BlockEntityRenderer<TrackBlockEntity, TrackRenderState> {
    public TrackRenderer(BlockEntityRendererProvider.Context context) {
    }

    public TrackRenderState createRenderState() {
        return new TrackRenderState();
    }

    public void extractRenderState(TrackBlockEntity be, TrackRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Level world = be.getLevel();
        if (VisualizationManager.supportsVisualization((LevelAccessor)world)) {
            return;
        }
        GirderRenderState girder = null;
        IdentityHashMap<TrackMaterial, TrackSegmentRenderState> tracks = null;
        for (BezierConnection bc : be.getConnections().values()) {
            int length;
            Object segment;
            if (!bc.isPrimary()) continue;
            BlockPos bePosition = (BlockPos)bc.bePositions.getFirst();
            if (bc.hasGirder) {
                segment = bc.getBakedGirders(GirderAngles::new);
                length = ((GirderAngles)segment).length;
                if (length > 1) {
                    if (girder == null) {
                        girder = GirderRenderState.create();
                    }
                    for (int i = 1; i < length; ++i) {
                        girder.add(LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)((GirderAngles)segment).lightPosition[i].offset((Vec3i)bePosition)), ((GirderAngles)segment).beams[i], ((GirderAngles)segment).beamCaps[i]);
                    }
                }
            }
            segment = bc.getBakedSegments(SegmentAngles::new);
            length = ((SegmentAngles)segment).length;
            if (length <= 1) continue;
            if (tracks == null) {
                tracks = new IdentityHashMap<TrackMaterial, TrackSegmentRenderState>();
            }
            TrackSegmentRenderState renderState = tracks.computeIfAbsent(bc.getMaterial(), TrackSegmentRenderState::create);
            for (int i = 1; i < length; ++i) {
                renderState.add(LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)((SegmentAngles)segment).lightPosition[i].offset((Vec3i)bePosition)), ((SegmentAngles)segment).tieTransform[i], ((SegmentAngles)segment).railTransforms[i]);
            }
        }
        if (tracks == null && girder == null) {
            return;
        }
        state.blockPos = be.getBlockPos();
        state.blockEntityType = be.getType();
        state.layer = RenderTypes.cutoutMovingBlock();
        state.girder = girder;
        state.tracks = tracks;
    }

    public void submit(TrackRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 192;
    }

    public static Vec3 getModelAngles(Vec3 normal, Vec3 diff) {
        double diffX = diff.x();
        double diffY = diff.y();
        double diffZ = diff.z();
        double len = Mth.sqrt((float)((float)(diffX * diffX + diffZ * diffZ)));
        double yaw = Mth.atan2((double)diffX, (double)diffZ);
        double pitch = Mth.atan2((double)len, (double)diffY) - 1.5707963267948966;
        Vec3 yawPitchNormal = VecHelper.rotate(VecHelper.rotate(new Vec3(0.0, 1.0, 0.0), AngleHelper.deg(pitch), Direction.Axis.X), AngleHelper.deg(yaw), Direction.Axis.Y);
        double signum = Math.signum(yawPitchNormal.dot(normal));
        if (Math.abs(signum) < 0.5) {
            signum = yawPitchNormal.distanceToSqr(normal) < 0.5 ? -1.0 : 1.0;
        }
        double dot = diff.cross(normal).normalize().dot(yawPitchNormal);
        double roll = Math.acos(Mth.clamp((double)dot, (double)-1.0, (double)1.0)) * signum;
        return new Vec3(pitch, yaw, roll);
    }

    public static class TrackRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public GirderRenderState girder;
        public Map<TrackMaterial, TrackSegmentRenderState> tracks;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.girder != null) {
                this.girder.render(matricesEntry, vertexConsumer);
            }
            if (this.tracks != null) {
                for (TrackSegmentRenderState track : this.tracks.values()) {
                    track.render(matricesEntry, vertexConsumer);
                }
            }
        }
    }

    public static class GirderAngles {
        public final int length;
        public final Couple<PoseStack.Pose>[] beams;
        public final Couple<Couple<PoseStack.Pose>>[] beamCaps;
        public final BlockPos[] lightPosition;

        GirderAngles(BezierConnection bc) {
            int segmentCount = bc.getSegmentCount();
            this.length = segmentCount + 1;
            this.beams = new Couple[this.length];
            this.beamCaps = new Couple[this.length];
            this.lightPosition = new BlockPos[this.length];
            Couple<Couple<Vec3>> previousOffsets = null;
            for (BezierConnection.Segment segment : bc) {
                int i = segment.index;
                boolean end = i == 0 || i == segmentCount;
                Vec3 leftGirder = segment.position.add(segment.normal.scale((double)0.965f));
                Vec3 rightGirder = segment.position.subtract(segment.normal.scale((double)0.965f));
                Vec3 upNormal = segment.derivative.normalize().cross(segment.normal);
                Vec3 firstGirderOffset = upNormal.scale(-0.5);
                Vec3 secondGirderOffset = upNormal.scale(-0.625);
                Vec3 leftTop = segment.position.add(segment.normal.scale(1.0)).add(firstGirderOffset);
                Vec3 rightTop = segment.position.subtract(segment.normal.scale(1.0)).add(firstGirderOffset);
                Vec3 leftBottom = leftTop.add(secondGirderOffset);
                Vec3 rightBottom = rightTop.add(secondGirderOffset);
                this.lightPosition[i] = BlockPos.containing((Position)leftGirder.add(rightGirder).scale(0.5));
                Couple<Couple<Vec3>> offsets = Couple.create(Couple.create(leftTop, rightTop), Couple.create(leftBottom, rightBottom));
                if (previousOffsets == null) {
                    previousOffsets = offsets;
                    continue;
                }
                this.beams[i] = Couple.create(null, null);
                this.beamCaps[i] = Couple.create(Couple.create(null, null), Couple.create(null, null));
                float scale = end ? 2.3f : 2.2f;
                for (boolean first : Iterate.trueAndFalse) {
                    Vec3 currentBeam = ((Vec3)((Couple)offsets.getFirst()).get(first)).add((Vec3)((Couple)offsets.getSecond()).get(first)).scale(0.5);
                    Vec3 previousBeam = ((Vec3)((Couple)previousOffsets.getFirst()).get(first)).add((Vec3)((Couple)previousOffsets.getSecond()).get(first)).scale(0.5);
                    Vec3 beamDiff = currentBeam.subtract(previousBeam);
                    Vec3 beamAngles = TrackRenderer.getModelAngles(segment.normal, beamDiff);
                    PoseStack poseStack = new PoseStack();
                    ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(previousBeam)).rotateY((float)beamAngles.y)).rotateX((float)beamAngles.x)).rotateZ((float)beamAngles.z)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f).scale(1.0f, 1.0f, (float)beamDiff.length() * scale);
                    this.beams[i].set(first, poseStack.last());
                    for (boolean top : Iterate.trueAndFalse) {
                        Vec3 current = offsets.get(top).get(first);
                        Vec3 previous = previousOffsets.get(top).get(first);
                        Vec3 diff = current.subtract(previous);
                        Vec3 capAngles = TrackRenderer.getModelAngles(segment.normal, diff);
                        poseStack = new PoseStack();
                        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(previous)).rotateY((float)capAngles.y)).rotateX((float)capAngles.x)).rotateZ((float)capAngles.z)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f).rotateZ(0.0f)).scale(1.0f, 1.0f, (float)diff.length() * scale);
                        this.beamCaps[i].get(top).set(first, poseStack.last());
                    }
                }
                previousOffsets = offsets;
            }
        }
    }

    public record GirderRenderState(SuperByteBuffer girderMiddle, SuperByteBuffer girderTop, SuperByteBuffer girderBottom, List<GirderSegmentData> girders) {
        public static GirderRenderState create() {
            BlockState air = Blocks.AIR.defaultBlockState();
            SuperByteBuffer middle = CachedBuffers.partial(AllPartialModels.GIRDER_SEGMENT_MIDDLE, air);
            SuperByteBuffer top = CachedBuffers.partial(AllPartialModels.GIRDER_SEGMENT_TOP, air);
            SuperByteBuffer bottom = CachedBuffers.partial(AllPartialModels.GIRDER_SEGMENT_BOTTOM, air);
            return new GirderRenderState(middle, top, bottom, new ArrayList<GirderSegmentData>());
        }

        public void add(int light, Couple<PoseStack.Pose> beam, Couple<Couple<PoseStack.Pose>> beamCap) {
            this.girders.add(new GirderSegmentData(light, beam, beamCap));
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (GirderSegmentData girder : this.girders) {
                for (boolean first : Iterate.trueAndFalse) {
                    PoseStack.Pose beamTransform = girder.beam.get(first);
                    ((SuperByteBuffer)((SuperByteBuffer)this.girderMiddle.mulPose((Matrix4fc)beamTransform.pose())).mulNormal((Matrix3fc)beamTransform.normal())).light(girder.light).renderInto(matricesEntry, vertexConsumer);
                    for (boolean top : Iterate.trueAndFalse) {
                        PoseStack.Pose beamCapTransform = girder.beamCaps.get(top).get(first);
                        ((SuperByteBuffer)((SuperByteBuffer)(top ? this.girderTop : this.girderBottom).mulPose((Matrix4fc)beamCapTransform.pose())).mulNormal((Matrix3fc)beamCapTransform.normal())).light(girder.light).renderInto(matricesEntry, vertexConsumer);
                    }
                }
            }
        }

        public record GirderSegmentData(int light, Couple<PoseStack.Pose> beam, Couple<Couple<PoseStack.Pose>> beamCaps) {
        }
    }

    public static class SegmentAngles {
        public final int length;
        @NotNull
        public final PoseStack.Pose[] tieTransform;
        @NotNull
        public final Couple<PoseStack.Pose>[] railTransforms;
        @NotNull
        public final BlockPos[] lightPosition;

        SegmentAngles(BezierConnection bc) {
            int segmentCount = bc.getSegmentCount();
            this.length = segmentCount + 1;
            this.tieTransform = new PoseStack.Pose[segmentCount + 1];
            this.railTransforms = new Couple[segmentCount + 1];
            this.lightPosition = new BlockPos[segmentCount + 1];
            Couple<Vec3> previousOffsets = null;
            for (BezierConnection.Segment segment : bc) {
                int i = segment.index;
                boolean end = i == 0 || i == segmentCount;
                Couple<Vec3> railOffsets = Couple.create(segment.position.add(segment.normal.scale((double)0.965f)), segment.position.subtract(segment.normal.scale((double)0.965f)));
                Vec3 railMiddle = ((Vec3)railOffsets.getFirst()).add((Vec3)railOffsets.getSecond()).scale(0.5);
                if (previousOffsets == null) {
                    previousOffsets = railOffsets;
                    continue;
                }
                Vec3 prevMiddle = ((Vec3)previousOffsets.getFirst()).add((Vec3)previousOffsets.getSecond()).scale(0.5);
                Vec3 tieAngles = TrackRenderer.getModelAngles(segment.normal, railMiddle.subtract(prevMiddle));
                this.lightPosition[i] = BlockPos.containing((Position)railMiddle);
                this.railTransforms[i] = Couple.create(null, null);
                PoseStack poseStack = new PoseStack();
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(prevMiddle)).rotateY((float)tieAngles.y)).rotateX((float)tieAngles.x)).rotateZ((float)tieAngles.z)).translate(-0.5f, -0.12890625f, 0.0f);
                this.tieTransform[i] = poseStack.last();
                float scale = end ? 2.2f : 2.1f;
                for (boolean first : Iterate.trueAndFalse) {
                    Vec3 railI = railOffsets.get(first);
                    Vec3 prevI = previousOffsets.get(first);
                    Vec3 diff = railI.subtract(prevI);
                    Vec3 anglesI = TrackRenderer.getModelAngles(segment.normal, diff);
                    poseStack = new PoseStack();
                    ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(poseStack).translate(prevI)).rotateY((float)anglesI.y)).rotateX((float)anglesI.x)).rotateZ((float)anglesI.z)).translate(0.0f, -0.12890625f, -0.03125f).scale(1.0f, 1.0f, (float)diff.length() * scale);
                    this.railTransforms[i].set(first, poseStack.last());
                }
                previousOffsets = railOffsets;
            }
        }
    }

    public record TrackSegmentRenderState(SuperByteBuffer tie, SuperByteBuffer left, SuperByteBuffer right, List<TrackSegmentData> tracks) {
        public static TrackSegmentRenderState create(TrackMaterial material) {
            AllTrackMaterialModels.TrackModelHolder modelHolder = (AllTrackMaterialModels.TrackModelHolder)material.getModelHolder();
            BlockState air = Blocks.AIR.defaultBlockState();
            SuperByteBuffer tie = CachedBuffers.partial(modelHolder.tie(), air);
            SuperByteBuffer left = CachedBuffers.partial(modelHolder.leftSegment(), air);
            SuperByteBuffer right = CachedBuffers.partial(modelHolder.rightSegment(), air);
            return new TrackSegmentRenderState(tie, left, right, new ArrayList<TrackSegmentData>());
        }

        public void add(int light, PoseStack.Pose tieTransform, Couple<PoseStack.Pose> railTransforms) {
            this.tracks.add(new TrackSegmentData(light, tieTransform, railTransforms));
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (TrackSegmentData track : this.tracks) {
                ((SuperByteBuffer)((SuperByteBuffer)this.tie.mulPose((Matrix4fc)track.tieTransform.pose())).mulNormal((Matrix3fc)track.tieTransform.normal())).light(track.light).renderInto(matricesEntry, vertexConsumer);
                for (boolean first : Iterate.trueAndFalse) {
                    PoseStack.Pose transform = track.railTransforms.get(first);
                    ((SuperByteBuffer)((SuperByteBuffer)(first ? this.left : this.right).mulPose((Matrix4fc)transform.pose())).mulNormal((Matrix3fc)transform.normal())).light(track.light).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }

        public record TrackSegmentData(int light, PoseStack.Pose tieTransform, Couple<PoseStack.Pose> railTransforms) {
        }
    }
}

