/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile.component;

import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.api.layout.Layout;
import com.zurrtum.create.client.flywheel.backend.compile.component.InstanceAssemblerComponent;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.FnSignature;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslBlock;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslBuilder;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslExpr;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslStmt;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import com.zurrtum.create.client.flywheel.lib.util.ResourceUtil;
import java.util.ArrayList;

public class SsboInstanceComponent
extends InstanceAssemblerComponent {
    public SsboInstanceComponent(InstanceType<?> type) {
        super(type);
    }

    @Override
    public String name() {
        return ResourceUtil.rl("ssbo_instance_assembler").toString();
    }

    @Override
    protected void generateUnpacking(GlslBuilder builder) {
        GlslBlock fnBody = new GlslBlock();
        int uintCount = MoreMath.ceilingDiv(this.layout.byteSize(), 4);
        fnBody.add(GlslStmt.raw("uint base = index * " + uintCount + "u;"));
        for (int i = 0; i < uintCount; ++i) {
            fnBody.add(GlslStmt.raw("uint u" + i + " = _flw_instances[base + " + i + "u];"));
        }
        ArrayList<GlslExpr> unpackArgs = new ArrayList<GlslExpr>();
        for (Layout.Element element : this.layout.elements()) {
            unpackArgs.add(this.unpackElement(element));
        }
        fnBody.ret(GlslExpr.call("FlwInstance", unpackArgs));
        builder._raw("layout(std430, binding = 1) restrict readonly buffer InstanceBuffer {\n    uint _flw_instances[];\n};");
        builder.blankLine();
        builder.function().signature(FnSignature.create().returnType("FlwInstance").name("_flw_unpackInstance").arg("uint", "index").build()).body(fnBody);
    }

    @Override
    protected GlslExpr access(int uintOffset) {
        return GlslExpr.variable("u" + uintOffset);
    }
}

