/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile.core;

import com.zurrtum.create.client.flywheel.backend.compile.core.LinkResult;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlShader;
import java.util.List;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL20;

public class ProgramLinker {
    public GlProgram link(List<GlShader> shaders, Consumer<GlProgram> preLink) {
        return this.linkInternal(shaders, preLink).unwrap();
    }

    private LinkResult linkInternal(List<GlShader> shaders, Consumer<GlProgram> preLink) {
        int handle = GL20.glCreateProgram();
        GlProgram out = new GlProgram(handle);
        for (GlShader shader : shaders) {
            GL20.glAttachShader((int)handle, (int)shader.handle());
        }
        preLink.accept(out);
        GL20.glLinkProgram((int)handle);
        String log = GL20.glGetProgramInfoLog((int)handle);
        if (ProgramLinker.linkSuccessful(handle)) {
            return LinkResult.success(out, log);
        }
        out.delete();
        return LinkResult.failure(log);
    }

    private static boolean linkSuccessful(int handle) {
        return GL20.glGetProgrami((int)handle, (int)35714) == 1;
    }
}

