/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.compile.core;

import com.zurrtum.create.client.flywheel.backend.compile.core.Compilation;
import com.zurrtum.create.client.flywheel.backend.compile.core.ShaderResult;
import com.zurrtum.create.client.flywheel.backend.gl.GlObject;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlShader;
import com.zurrtum.create.client.flywheel.backend.gl.shader.ShaderType;
import com.zurrtum.create.client.flywheel.backend.glsl.GlslVersion;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceComponent;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class ShaderCache {
    private final Map<ShaderKey, ShaderResult> inner = new HashMap<ShaderKey, ShaderResult>();

    public GlShader compile(GlslVersion glslVersion, ShaderType shaderType, String name, Consumer<Compilation> callback, List<SourceComponent> sourceComponents) {
        ShaderKey key = new ShaderKey(glslVersion, shaderType, name);
        ShaderResult cached = this.inner.get(key);
        if (cached != null) {
            return cached.unwrap();
        }
        Compilation ctx = new Compilation();
        ctx.version(glslVersion);
        ctx.define(shaderType.define);
        callback.accept(ctx);
        ShaderCache.expand(sourceComponents, ctx::appendComponent);
        ShaderResult out = ctx.compile(shaderType, name);
        this.inner.put(key, out);
        return out.unwrap();
    }

    public void delete() {
        this.inner.values().stream().filter(r -> r instanceof ShaderResult.Success).map(ShaderResult::unwrap).forEach(GlObject::delete);
        this.inner.clear();
    }

    private static void expand(List<SourceComponent> rootSources, Consumer<SourceComponent> out) {
        LinkedHashSet<SourceComponent> included = new LinkedHashSet<SourceComponent>();
        for (SourceComponent component : rootSources) {
            ShaderCache.recursiveDepthFirstInclude(included, component);
            included.add(component);
        }
        included.forEach(out);
    }

    private static void recursiveDepthFirstInclude(Set<SourceComponent> included, SourceComponent component) {
        for (SourceComponent sourceComponent : component.included()) {
            ShaderCache.recursiveDepthFirstInclude(included, sourceComponent);
        }
        included.addAll(component.included());
    }

    private record ShaderKey(GlslVersion glslVersion, ShaderType shaderType, String name) {
    }
}

