/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.backend.engine.AbstractInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.InstanceHandleImpl;
import com.zurrtum.create.client.flywheel.backend.engine.InstancerKey;
import com.zurrtum.create.client.flywheel.backend.util.AtomicBitSet;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInstancer<I extends Instance>
extends AbstractInstancer<I>
implements InstanceHandleImpl.State<I> {
    protected final Object lock = new Object();
    protected final ArrayList<I> instances = new ArrayList();
    protected final ArrayList<InstanceHandleImpl<I>> handles = new ArrayList();
    protected final AtomicBitSet changed = new AtomicBitSet();
    protected final AtomicBitSet deleted = new AtomicBitSet();

    protected BaseInstancer(InstancerKey<I> key, AbstractInstancer.Recreate<I> recreate) {
        super(key, recreate);
    }

    @Override
    public InstanceHandleImpl.State<I> setChanged(int index) {
        this.notifyDirty(index);
        return this;
    }

    @Override
    public InstanceHandleImpl.State<I> setDeleted(int index) {
        this.notifyRemoval(index);
        return InstanceHandleImpl.Deleted.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceHandleImpl.State<I> setVisible(InstanceHandleImpl<I> handle, int index, boolean visible) {
        Instance instance;
        if (visible) {
            return this;
        }
        this.notifyRemoval(index);
        Object object = this.lock;
        synchronized (object) {
            instance = (Instance)this.instances.get(index);
        }
        return new InstanceHandleImpl.Hidden<Instance>(this.recreate, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public I createInstance() {
        InstanceHandleImpl handle = new InstanceHandleImpl(this);
        Object instance = this.type.create(handle);
        Object object = this.lock;
        synchronized (object) {
            handle.index = this.instances.size();
            this.addLocked(instance, handle);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstanceHandleImpl.State<I> revealInstance(InstanceHandleImpl<I> handle, I instance) {
        Object object = this.lock;
        synchronized (object) {
            handle.index = this.instances.size();
            this.addLocked(instance, handle);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stealInstance(@Nullable I instance) {
        InstanceHandleImpl.Hidden hidden;
        if (instance == null) {
            return;
        }
        InstanceHandle instanceHandle = instance.handle();
        if (!(instanceHandle instanceof InstanceHandleImpl)) {
            return;
        }
        InstanceHandleImpl handle = (InstanceHandleImpl)instanceHandle;
        if (handle.state == this) {
            return;
        }
        if (handle.state instanceof InstanceHandleImpl.Deleted) {
            return;
        }
        InstanceHandleImpl.State state = handle.state;
        if (state instanceof InstanceHandleImpl.Hidden && this.recreate.equals((hidden = (InstanceHandleImpl.Hidden)state).recreate())) {
            return;
        }
        state = handle.state;
        if (state instanceof BaseInstancer) {
            BaseInstancer other = (BaseInstancer)state;
            other.notifyRemoval(handle.index);
            handle.state = this;
            state = this.lock;
            synchronized (state) {
                handle.index = this.instances.size();
                this.addLocked(instance, handle);
            }
        } else if (handle.state instanceof InstanceHandleImpl.Hidden) {
            handle.state = new InstanceHandleImpl.Hidden<I>(this.recreate, instance);
        }
    }

    private void addLocked(I instance, InstanceHandleImpl<I> handle) {
        this.instances.add(instance);
        this.handles.add(handle);
        this.setIndexChanged(handle.index);
    }

    @Override
    public int instanceCount() {
        return this.instances.size();
    }

    public void notifyDirty(int index) {
        if (index < 0 || index >= this.instanceCount()) {
            return;
        }
        this.setIndexChanged(index);
    }

    protected void setIndexChanged(int index) {
        this.changed.set(index);
    }

    public void notifyRemoval(int index) {
        if (index < 0 || index >= this.instanceCount()) {
            return;
        }
        this.deleted.set(index);
    }

    @Override
    public void clear() {
        for (InstanceHandleImpl<I> handle : this.handles) {
            if (handle.state != this) continue;
            handle.clear();
            handle.state = InstanceHandleImpl.Deleted.instance();
        }
        this.instances.clear();
        this.handles.clear();
        this.changed.clear();
        this.deleted.clear();
    }
}

