/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.backend.engine.AbstractArena;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;

public class CpuArena
extends AbstractArena {
    private MemoryBlock memoryBlock;

    public CpuArena(long elementSizeBytes, int initialCapacity) {
        super(elementSizeBytes);
        this.memoryBlock = MemoryBlock.malloc(elementSizeBytes * (long)initialCapacity);
    }

    public long indexToPointer(int i) {
        return this.memoryBlock.ptr() + (long)i * this.elementSizeBytes;
    }

    public void delete() {
        this.memoryBlock.free();
    }

    @Override
    public long byteCapacity() {
        return this.memoryBlock.size();
    }

    @Override
    protected void grow() {
        this.memoryBlock = this.memoryBlock.realloc(this.memoryBlock.size() * 2L);
    }
}

