/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.api.model.IndexSequence;
import com.zurrtum.create.client.flywheel.backend.gl.array.GlVertexArray;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBuffer;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBufferUsage;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;

public class IndexPool {
    private final GlBuffer ebo = new GlBuffer(GlBufferUsage.DYNAMIC_DRAW);
    private final Reference2IntMap<IndexSequence> indexCounts = new Reference2IntOpenHashMap();
    private final Reference2IntMap<IndexSequence> firstIndices = new Reference2IntOpenHashMap();
    private boolean dirty;

    public IndexPool() {
        this.indexCounts.defaultReturnValue(0);
    }

    public int firstIndex(IndexSequence sequence) {
        return this.firstIndices.getInt((Object)sequence);
    }

    public void reset() {
        this.indexCounts.clear();
        this.firstIndices.clear();
        this.dirty = true;
    }

    public void updateCount(IndexSequence sequence, int indexCount) {
        int oldCount = this.indexCounts.getInt((Object)sequence);
        int newCount = Math.max(oldCount, indexCount);
        if (newCount > oldCount) {
            this.indexCounts.put((Object)sequence, newCount);
            this.dirty = true;
        }
    }

    public void flush() {
        if (!this.dirty) {
            return;
        }
        this.firstIndices.clear();
        this.dirty = false;
        long totalIndexCount = 0L;
        IntIterator intIterator = this.indexCounts.values().iterator();
        while (intIterator.hasNext()) {
            int count = (Integer)intIterator.next();
            totalIndexCount += (long)count;
        }
        MemoryBlock indexBlock = MemoryBlock.malloc(totalIndexCount * 4L);
        long indexPtr = indexBlock.ptr();
        int firstIndex = 0;
        for (Reference2IntMap.Entry entries : this.indexCounts.reference2IntEntrySet()) {
            IndexSequence indexSequence = (IndexSequence)entries.getKey();
            int indexCount = entries.getIntValue();
            this.firstIndices.put((Object)indexSequence, firstIndex);
            indexSequence.fill(indexPtr + (long)firstIndex * 4L, indexCount);
            firstIndex += indexCount;
        }
        this.ebo.upload(indexBlock);
        indexBlock.free();
    }

    public void bind(GlVertexArray vertexArray) {
        vertexArray.setElementBuffer(this.ebo.handle());
    }

    public void delete() {
        this.ebo.delete();
    }
}

