/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.zurrtum.create.client.flywheel.backend.engine.LightStorage;
import com.zurrtum.create.client.flywheel.impl.compat.CompatMod;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import java.util.BitSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.SkyLightSectionStorage;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public abstract class LightDataCollector {
    private static final ConstantDataLayer ALWAYS_0 = new ConstantDataLayer(0);
    private static final ConstantDataLayer ALWAYS_15 = new ConstantDataLayer(15);
    protected final LevelAccessor level;
    protected final LayerLightEventListener skyLayerListener;
    protected final LayerLightEventListener blockLayerListener;

    protected LightDataCollector(LevelAccessor level, LayerLightEventListener skyLayerListener, LayerLightEventListener blockLayerListener) {
        this.level = level;
        this.skyLayerListener = skyLayerListener;
        this.blockLayerListener = blockLayerListener;
    }

    public static LightDataCollector of(LevelAccessor level) {
        LayerLightEventListener skyLayerListener = level.getLightEngine().getLayerListener(LightLayer.SKY);
        LayerLightEventListener blockLayerListener = level.getLightEngine().getLayerListener(LightLayer.BLOCK);
        Long2ObjectFunction<DataLayer> fastSkyDataGetter = LightDataCollector.createFastSkyDataGetter(skyLayerListener);
        Long2ObjectFunction<DataLayer> fastBlockDataGetter = LightDataCollector.createFastBlockDataGetter(blockLayerListener);
        if (fastSkyDataGetter != null && fastBlockDataGetter != null) {
            return new Fast(level, skyLayerListener, blockLayerListener, fastSkyDataGetter, fastBlockDataGetter);
        }
        return new Slow(level, skyLayerListener, blockLayerListener);
    }

    private static DataLayer getSkyDataLayer(SkyLightSectionStorage skyStorage, long section) {
        long l = section;
        int i = SectionPos.y((long)l);
        SkyLightSectionStorage.SkyDataLayerStorageMap skyDataLayerStorageMap = (SkyLightSectionStorage.SkyDataLayerStorageMap)skyStorage.visibleSectionData;
        int j = skyDataLayerStorageMap.topSections.get(SectionPos.getZeroNode((long)l));
        if (j != skyDataLayerStorageMap.currentLowestY && i < j) {
            DataLayer dataLayer = skyStorage.getDataLayerData(l);
            if (dataLayer == null) {
                while (dataLayer == null) {
                    if (++i >= j) {
                        return null;
                    }
                    l = SectionPos.offset((long)l, (Direction)Direction.UP);
                    dataLayer = skyStorage.getDataLayerData(l);
                }
            }
            return dataLayer;
        }
        return null;
    }

    @Nullable
    private static Long2ObjectFunction<DataLayer> createFastSkyDataGetter(LayerLightEventListener layerListener) {
        if (layerListener == LayerLightEventListener.DummyLightLayerEventListener.INSTANCE) {
            return section -> ALWAYS_0;
        }
        if (layerListener instanceof LightEngine) {
            LightEngine accessor = (LightEngine)layerListener;
            LayerLightSectionStorage layerLightSectionStorage = accessor.storage;
            if (layerLightSectionStorage instanceof SkyLightSectionStorage) {
                SkyLightSectionStorage skyStorage = (SkyLightSectionStorage)layerLightSectionStorage;
                return section -> {
                    DataLayer out = LightDataCollector.getSkyDataLayer(skyStorage, section);
                    return Objects.requireNonNullElse(out, ALWAYS_15);
                };
            }
        }
        if (CompatMod.SCALABLELUX.isLoaded) {
            return section -> Objects.requireNonNullElse(layerListener.getDataLayerData(SectionPos.of((long)section)), ALWAYS_15);
        }
        return null;
    }

    @Nullable
    private static Long2ObjectFunction<DataLayer> createFastBlockDataGetter(LayerLightEventListener layerListener) {
        if (layerListener == LayerLightEventListener.DummyLightLayerEventListener.INSTANCE) {
            return section -> ALWAYS_0;
        }
        if (layerListener instanceof LightEngine) {
            LightEngine accessor = (LightEngine)layerListener;
            LayerLightSectionStorage storage = accessor.storage;
            return section -> {
                DataLayer out = storage.getDataLayer(section, false);
                return Objects.requireNonNullElse(out, ALWAYS_0);
            };
        }
        if (CompatMod.SCALABLELUX.isLoaded) {
            return section -> Objects.requireNonNullElse(layerListener.getDataLayerData(SectionPos.of((long)section)), ALWAYS_0);
        }
        return null;
    }

    public void collectSection(long ptr, long section) {
        this.collectSolidData(ptr, section);
        this.collectLightData(ptr, section);
    }

    private void collectSolidData(long ptr, long section) {
        long[] longArray;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int xMin = SectionPos.sectionToBlockCoord((int)SectionPos.x((long)section));
        int yMin = SectionPos.sectionToBlockCoord((int)SectionPos.y((long)section));
        int zMin = SectionPos.sectionToBlockCoord((int)SectionPos.z((long)section));
        BitSet bitSet = new BitSet(5832);
        int index = 0;
        for (int y = -1; y < 17; ++y) {
            for (int z = -1; z < 17; ++z) {
                for (int x = -1; x < 17; ++x) {
                    blockPos.set(xMin + x, yMin + y, zMin + z);
                    BlockState blockState = this.level.getBlockState((BlockPos)blockPos);
                    if (blockState.canOcclude() && blockState.isCollisionShapeFullBlock((BlockGetter)this.level, (BlockPos)blockPos)) {
                        bitSet.set(index);
                    }
                    ++index;
                }
            }
        }
        for (long l : longArray = bitSet.toLongArray()) {
            MemoryUtil.memPutLong((long)ptr, (long)l);
            ptr += 8L;
        }
    }

    protected abstract void collectLightData(long var1, long var3);

    protected static void write(long ptr, int x, int y, int z, int block, int sky) {
        int x1 = x + 1;
        int y1 = y + 1;
        int z1 = z + 1;
        int offset = x1 + z1 * 18 + y1 * 18 * 18;
        long packedByte = block & 0xF | (sky & 0xF) << 4;
        MemoryUtil.memPutByte((long)(ptr + (long)LightStorage.SOLID_SIZE_BYTES + (long)offset), (byte)((byte)packedByte));
    }

    private static class Fast
    extends LightDataCollector {
        private final Long2ObjectFunction<DataLayer> skyDataGetter;
        private final Long2ObjectFunction<DataLayer> blockDataGetter;

        public Fast(LevelAccessor level, LayerLightEventListener skyLayerListener, LayerLightEventListener blockLayerListener, Long2ObjectFunction<DataLayer> skyDataGetter, Long2ObjectFunction<DataLayer> blockDataGetter) {
            super(level, skyLayerListener, blockLayerListener);
            this.skyDataGetter = skyDataGetter;
            this.blockDataGetter = blockDataGetter;
        }

        @Override
        protected void collectLightData(long ptr, long section) {
            this.collectCenter(ptr, section);
            for (SectionEdge i : SectionEdge.VALUES) {
                this.collectYZPlane(ptr, SectionPos.offset((long)section, (int)i.sectionOffset, (int)0, (int)0), i);
                this.collectXZPlane(ptr, SectionPos.offset((long)section, (int)0, (int)i.sectionOffset, (int)0), i);
                this.collectXYPlane(ptr, SectionPos.offset((long)section, (int)0, (int)0, (int)i.sectionOffset), i);
                for (SectionEdge j : SectionEdge.VALUES) {
                    this.collectXStrip(ptr, SectionPos.offset((long)section, (int)0, (int)i.sectionOffset, (int)j.sectionOffset), i, j);
                    this.collectYStrip(ptr, SectionPos.offset((long)section, (int)i.sectionOffset, (int)0, (int)j.sectionOffset), i, j);
                    this.collectZStrip(ptr, SectionPos.offset((long)section, (int)i.sectionOffset, (int)j.sectionOffset, (int)0), i, j);
                }
            }
            this.collectCorners(ptr, section);
        }

        private void collectXStrip(long ptr, long section, SectionEdge y, SectionEdge z) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int x = 0; x < 16; ++x) {
                Fast.write(ptr, x, y.relative, z.relative, blockData.get(x, y.pos, z.pos), skyData.get(x, y.pos, z.pos));
            }
        }

        private void collectYStrip(long ptr, long section, SectionEdge x, SectionEdge z) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                Fast.write(ptr, x.relative, y, z.relative, blockData.get(x.pos, y, z.pos), skyData.get(x.pos, y, z.pos));
            }
        }

        private void collectZStrip(long ptr, long section, SectionEdge x, SectionEdge y) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int z = 0; z < 16; ++z) {
                Fast.write(ptr, x.relative, y.relative, z, blockData.get(x.pos, y.pos, z), skyData.get(x.pos, y.pos, z));
            }
        }

        private void collectYZPlane(long ptr, long section, SectionEdge x) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Fast.write(ptr, x.relative, y, z, blockData.get(x.pos, y, z), skyData.get(x.pos, y, z));
                }
            }
        }

        private void collectXZPlane(long ptr, long section, SectionEdge y) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Fast.write(ptr, x, y.relative, z, blockData.get(x, y.pos, z), skyData.get(x, y.pos, z));
                }
            }
        }

        private void collectXYPlane(long ptr, long section, SectionEdge z) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    Fast.write(ptr, x, y, z.relative, blockData.get(x, y, z.pos), skyData.get(x, y, z.pos));
                }
            }
        }

        private void collectCenter(long ptr, long section) {
            DataLayer blockData = (DataLayer)this.blockDataGetter.get(section);
            DataLayer skyData = (DataLayer)this.skyDataGetter.get(section);
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        Fast.write(ptr, x, y, z, blockData.get(x, y, z), skyData.get(x, y, z));
                    }
                }
            }
        }

        private void collectCorners(long ptr, long section) {
            LayerLightEventListener blockLayerListener = this.blockLayerListener;
            LayerLightEventListener skyLayerListener = this.skyLayerListener;
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            int xMin = SectionPos.sectionToBlockCoord((int)SectionPos.x((long)section));
            int yMin = SectionPos.sectionToBlockCoord((int)SectionPos.y((long)section));
            int zMin = SectionPos.sectionToBlockCoord((int)SectionPos.z((long)section));
            for (SectionEdge y : SectionEdge.VALUES) {
                for (SectionEdge z : SectionEdge.VALUES) {
                    for (SectionEdge x : SectionEdge.VALUES) {
                        blockPos.set(x.relative + xMin, y.relative + yMin, z.relative + zMin);
                        Fast.write(ptr, x.relative, y.relative, z.relative, blockLayerListener.getLightValue((BlockPos)blockPos), skyLayerListener.getLightValue((BlockPos)blockPos));
                    }
                }
            }
        }

        private static enum SectionEdge {
            LOW(15, -1, -1),
            HIGH(0, 16, 1);

            public static final SectionEdge[] VALUES;
            private final int pos;
            private final int relative;
            private final int sectionOffset;

            private SectionEdge(int pos, int relative, int sectionOffset) {
                this.pos = pos;
                this.relative = relative;
                this.sectionOffset = sectionOffset;
            }

            static {
                VALUES = SectionEdge.values();
            }
        }
    }

    private static class Slow
    extends LightDataCollector {
        public Slow(LevelAccessor level, LayerLightEventListener skyLayerListener, LayerLightEventListener blockLayerListener) {
            super(level, skyLayerListener, blockLayerListener);
        }

        @Override
        protected void collectLightData(long ptr, long section) {
            LayerLightEventListener blockLayerListener = this.blockLayerListener;
            LayerLightEventListener skyLayerListener = this.skyLayerListener;
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            int xMin = SectionPos.sectionToBlockCoord((int)SectionPos.x((long)section));
            int yMin = SectionPos.sectionToBlockCoord((int)SectionPos.y((long)section));
            int zMin = SectionPos.sectionToBlockCoord((int)SectionPos.z((long)section));
            for (int y = -1; y < 17; ++y) {
                for (int z = -1; z < 17; ++z) {
                    for (int x = -1; x < 17; ++x) {
                        blockPos.set(xMin + x, yMin + y, zMin + z);
                        Slow.write(ptr, x, y, z, blockLayerListener.getLightValue((BlockPos)blockPos), skyLayerListener.getLightValue((BlockPos)blockPos));
                    }
                }
            }
        }
    }

    private static class ConstantDataLayer
    extends DataLayer {
        private final int value;

        private ConstantDataLayer(int value) {
            this.value = value;
        }

        public int get(int x, int y, int z) {
            return this.value;
        }
    }
}

