/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine;

import com.mojang.blaze3d.opengl.GlSampler;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.flywheel.backend.Samplers;
import com.zurrtum.create.client.flywheel.backend.gl.GlTextureUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.Identifier;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL33C;

public class TextureBinder {
    public static void bind(Identifier Identifier2) {
        GlStateManager._bindTexture((int)TextureBinder.byName(Identifier2));
    }

    public static void bindCrumbling(Identifier Identifier2) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(Identifier2);
        TextureBinder.setupTexture(Samplers.CRUMBLING, texture.getTextureView(), texture.getSampler());
    }

    public static void bindLightAndOverlay() {
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        GpuSampler sampler = RenderSystem.getSamplerCache().getClampToEdge(FilterMode.LINEAR);
        TextureBinder.setupTexture(Samplers.OVERLAY, gameRenderer.overlayTexture().getTextureView(), sampler);
        TextureBinder.setupTexture(Samplers.LIGHT, gameRenderer.lightTexture().getTextureView(), sampler);
    }

    private static void setupTexture(GlTextureUnit unit, GpuTextureView textureView, GpuSampler sampler) {
        int target;
        unit.makeActive();
        GlTexture texture = (GlTexture)textureView.texture();
        if ((texture.usage() & 0x10) != 0) {
            target = 34067;
            GL11.glBindTexture((int)target, (int)texture.glId());
        } else {
            target = 3553;
            GlStateManager._bindTexture((int)texture.glId());
        }
        GL33C.glBindSampler((int)unit.number, (int)((GlSampler)sampler).getId());
        int mipLevel = textureView.baseMipLevel();
        GlStateManager._texParameter((int)target, (int)33084, (int)mipLevel);
        GlStateManager._texParameter((int)target, (int)33085, (int)(mipLevel + textureView.mipLevels() - 1));
    }

    public static void resetLightAndOverlay() {
    }

    public static int byName(Identifier texture) {
        return ((GlTexture)Minecraft.getInstance().getTextureManager().getTexture(texture).getTexture()).glId();
    }
}

