/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.indirect;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.client.flywheel.backend.NoiseTextures;
import com.zurrtum.create.client.flywheel.backend.Samplers;
import com.zurrtum.create.client.flywheel.backend.compile.OitPrograms;
import com.zurrtum.create.client.flywheel.backend.gl.GlCompat;
import com.zurrtum.create.client.flywheel.backend.gl.GlTextureUnit;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL46;

public class OitFramebuffer {
    public static final float[] CLEAR_TO_ZERO = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public static final int[] DEPTH_RANGE_DRAW_BUFFERS = new int[]{36064};
    public static final int[] RENDER_TRANSMITTANCE_DRAW_BUFFERS = new int[]{36065, 36066, 36067, 36068};
    public static final int[] ACCUMULATE_DRAW_BUFFERS = new int[]{36069};
    public static final int[] DEPTH_ONLY_DRAW_BUFFERS = new int[0];
    private final OitPrograms programs;
    private final int vao;
    public int fbo = -1;
    public int depthBounds = -1;
    public int coefficients = -1;
    public int accumulate = -1;
    private int lastWidth = -1;
    private int lastHeight = -1;

    public OitFramebuffer(OitPrograms programs) {
        this.programs = programs;
        this.vao = GlCompat.SUPPORTS_DSA ? GL46.glCreateVertexArrays() : GL32.glGenVertexArrays();
    }

    public void prepare() {
        RenderTarget renderTarget;
        if (Minecraft.useShaderTransparency()) {
            renderTarget = Minecraft.getInstance().levelRenderer.getItemEntityTarget();
            renderTarget.copyDepthFrom(Minecraft.getInstance().getMainRenderTarget());
        } else {
            renderTarget = Minecraft.getInstance().getMainRenderTarget();
        }
        this.maybeResizeFBO(renderTarget.width, renderTarget.height);
        Samplers.COEFFICIENTS.makeActive();
        GlStateManager._bindTexture((int)0);
        GL32.glBindTexture((int)35866, (int)this.coefficients);
        Samplers.DEPTH_RANGE.makeActive();
        GlStateManager._bindTexture((int)this.depthBounds);
        Samplers.NOISE.makeActive();
        GlStateManager._bindTexture((int)((GlTexture)NoiseTextures.BLUE_NOISE.getTexture()).glId());
        GlStateManager._glBindFramebuffer((int)36160, (int)this.fbo);
        GL32.glFramebufferTexture((int)36160, (int)36096, (int)((GlTexture)renderTarget.getDepthTexture()).glId(), (int)0);
    }

    public void depthRange() {
        GlStateManager._depthMask((boolean)false);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)1, (int)1, (int)1, (int)1);
        GL14.glBlendEquation((int)32776);
        float far = Minecraft.getInstance().gameRenderer.getDepthFar();
        if (GlCompat.SUPPORTS_DSA) {
            GL46.glNamedFramebufferDrawBuffers((int)this.fbo, (int[])DEPTH_RANGE_DRAW_BUFFERS);
            GL46.glClearNamedFramebufferfv((int)this.fbo, (int)6144, (int)0, (float[])new float[]{-far, -far, 0.0f, 0.0f});
        } else {
            GL32.glDrawBuffers((int[])DEPTH_RANGE_DRAW_BUFFERS);
            GL11.glClearColor((float)(-far), (float)(-far), (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16384);
        }
    }

    public void renderTransmittance() {
        GlStateManager._depthMask((boolean)false);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)1, (int)1, (int)1, (int)1);
        GL14.glBlendEquation((int)32774);
        if (GlCompat.SUPPORTS_DSA) {
            GL46.glNamedFramebufferDrawBuffers((int)this.fbo, (int[])RENDER_TRANSMITTANCE_DRAW_BUFFERS);
            GL46.glClearNamedFramebufferfv((int)this.fbo, (int)6144, (int)0, (float[])CLEAR_TO_ZERO);
            GL46.glClearNamedFramebufferfv((int)this.fbo, (int)6144, (int)1, (float[])CLEAR_TO_ZERO);
            GL46.glClearNamedFramebufferfv((int)this.fbo, (int)6144, (int)2, (float[])CLEAR_TO_ZERO);
            GL46.glClearNamedFramebufferfv((int)this.fbo, (int)6144, (int)3, (float[])CLEAR_TO_ZERO);
        } else {
            GL32.glDrawBuffers((int[])RENDER_TRANSMITTANCE_DRAW_BUFFERS);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16384);
        }
    }

    public void renderDepthFromTransmittance() {
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager._disableBlend();
        GlStateManager._depthFunc((int)519);
        if (GlCompat.SUPPORTS_DSA) {
            GL46.glNamedFramebufferDrawBuffers((int)this.fbo, (int[])DEPTH_ONLY_DRAW_BUFFERS);
        } else {
            GL32.glDrawBuffers((int[])DEPTH_ONLY_DRAW_BUFFERS);
        }
        this.programs.getOitDepthProgram().bind();
        this.drawFullscreenQuad();
    }

    public void accumulate() {
        GlStateManager._depthMask((boolean)false);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)1, (int)1, (int)1, (int)1);
        GL14.glBlendEquation((int)32774);
        if (GlCompat.SUPPORTS_DSA) {
            GL46.glNamedFramebufferDrawBuffers((int)this.fbo, (int[])ACCUMULATE_DRAW_BUFFERS);
            GL46.glClearNamedFramebufferfv((int)this.fbo, (int)6144, (int)0, (float[])CLEAR_TO_ZERO);
        } else {
            GL32.glDrawBuffers((int[])ACCUMULATE_DRAW_BUFFERS);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16384);
        }
    }

    public void composite() {
        int i;
        RenderTarget framebuffer;
        if (Minecraft.useShaderTransparency()) {
            framebuffer = Minecraft.getInstance().levelRenderer.getItemEntityTarget();
            i = ((GlTexture)framebuffer.getColorTexture()).getFbo(((GlDevice)RenderSystem.getDevice()).directStateAccess(), framebuffer.getDepthTexture());
            GlStateManager._glBindFramebuffer((int)36160, (int)i);
        } else {
            framebuffer = Minecraft.getInstance().getMainRenderTarget();
            i = ((GlTexture)framebuffer.getColorTexture()).getFbo(((GlDevice)RenderSystem.getDevice()).directStateAccess(), framebuffer.getDepthTexture());
            GlStateManager._glBindFramebuffer((int)36160, (int)i);
        }
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableBlend();
        GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL14.glBlendEquation((int)32774);
        GlStateManager._depthFunc((int)519);
        GlTextureUnit.T0.makeActive();
        GlStateManager._bindTexture((int)this.accumulate);
        this.programs.getOitCompositeProgram().bind();
        this.drawFullscreenQuad();
        framebuffer = Minecraft.getInstance().getMainRenderTarget();
        i = ((GlTexture)framebuffer.getColorTexture()).getFbo(((GlDevice)RenderSystem.getDevice()).directStateAccess(), framebuffer.getDepthTexture());
        GlStateManager._glBindFramebuffer((int)36160, (int)i);
    }

    public void delete() {
        this.deleteTextures();
        GL32.glDeleteVertexArrays((int)this.vao);
    }

    private void drawFullscreenQuad() {
        GlStateManager._glBindVertexArray((int)this.vao);
        GL32.glDrawArrays((int)4, (int)0, (int)3);
    }

    private void deleteTextures() {
        if (this.depthBounds != -1) {
            GL32.glDeleteTextures((int)this.depthBounds);
        }
        if (this.coefficients != -1) {
            GL32.glDeleteTextures((int)this.coefficients);
        }
        if (this.accumulate != -1) {
            GL32.glDeleteTextures((int)this.accumulate);
        }
        if (this.fbo != -1) {
            GL32.glDeleteFramebuffers((int)this.fbo);
        }
        Samplers.COEFFICIENTS.makeActive();
        GlStateManager._bindTexture((int)0);
        Samplers.DEPTH_RANGE.makeActive();
        GlStateManager._bindTexture((int)0);
    }

    private void maybeResizeFBO(int width, int height) {
        if (this.lastWidth == width && this.lastHeight == height) {
            return;
        }
        this.lastWidth = width;
        this.lastHeight = height;
        this.deleteTextures();
        if (GlCompat.SUPPORTS_DSA) {
            this.fbo = GL46.glCreateFramebuffers();
            this.depthBounds = GL46.glCreateTextures((int)3553);
            this.coefficients = GL46.glCreateTextures((int)35866);
            this.accumulate = GL46.glCreateTextures((int)3553);
            GL46.glTextureStorage2D((int)this.depthBounds, (int)1, (int)33328, (int)width, (int)height);
            GL46.glTextureStorage3D((int)this.coefficients, (int)1, (int)34842, (int)width, (int)height, (int)4);
            GL46.glTextureStorage2D((int)this.accumulate, (int)1, (int)34842, (int)width, (int)height);
            GL46.glNamedFramebufferTexture((int)this.fbo, (int)36064, (int)this.depthBounds, (int)0);
            GL46.glNamedFramebufferTextureLayer((int)this.fbo, (int)36065, (int)this.coefficients, (int)0, (int)0);
            GL46.glNamedFramebufferTextureLayer((int)this.fbo, (int)36066, (int)this.coefficients, (int)0, (int)1);
            GL46.glNamedFramebufferTextureLayer((int)this.fbo, (int)36067, (int)this.coefficients, (int)0, (int)2);
            GL46.glNamedFramebufferTextureLayer((int)this.fbo, (int)36068, (int)this.coefficients, (int)0, (int)3);
            GL46.glNamedFramebufferTexture((int)this.fbo, (int)36069, (int)this.accumulate, (int)0);
        } else {
            this.fbo = GL46.glGenFramebuffers();
            this.depthBounds = GL32.glGenTextures();
            this.coefficients = GL32.glGenTextures();
            this.accumulate = GL32.glGenTextures();
            GlTextureUnit.T0.makeActive();
            GlStateManager._bindTexture((int)0);
            GL32.glBindTexture((int)3553, (int)this.depthBounds);
            GL32.glTexImage2D((int)3553, (int)0, (int)33328, (int)width, (int)height, (int)0, (int)6408, (int)5120, (long)0L);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL32.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL32.glBindTexture((int)35866, (int)this.coefficients);
            GL32.glTexImage3D((int)35866, (int)0, (int)34842, (int)width, (int)height, (int)4, (int)0, (int)6408, (int)5120, (long)0L);
            GL32.glTexParameteri((int)35866, (int)10241, (int)9728);
            GL32.glTexParameteri((int)35866, (int)10240, (int)9728);
            GL32.glTexParameteri((int)35866, (int)10242, (int)33071);
            GL32.glTexParameteri((int)35866, (int)10243, (int)33071);
            GL32.glBindTexture((int)3553, (int)this.accumulate);
            GL32.glTexImage2D((int)3553, (int)0, (int)34842, (int)width, (int)height, (int)0, (int)6408, (int)5120, (long)0L);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL32.glTexParameteri((int)3553, (int)10243, (int)33071);
            GlStateManager._glBindFramebuffer((int)36160, (int)this.fbo);
            GL46.glFramebufferTexture((int)36160, (int)36064, (int)this.depthBounds, (int)0);
            GL46.glFramebufferTextureLayer((int)36160, (int)36065, (int)this.coefficients, (int)0, (int)0);
            GL46.glFramebufferTextureLayer((int)36160, (int)36066, (int)this.coefficients, (int)0, (int)1);
            GL46.glFramebufferTextureLayer((int)36160, (int)36067, (int)this.coefficients, (int)0, (int)2);
            GL46.glFramebufferTextureLayer((int)36160, (int)36068, (int)this.coefficients, (int)0, (int)3);
            GL46.glFramebufferTexture((int)36160, (int)36069, (int)this.accumulate, (int)0);
        }
    }
}

