/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.instancing;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.client.flywheel.api.backend.Engine;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.backend.Samplers;
import com.zurrtum.create.client.flywheel.backend.compile.ContextShader;
import com.zurrtum.create.client.flywheel.backend.compile.InstancingPrograms;
import com.zurrtum.create.client.flywheel.backend.compile.PipelineCompiler;
import com.zurrtum.create.client.flywheel.backend.engine.AbstractInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.CommonCrumbling;
import com.zurrtum.create.client.flywheel.backend.engine.DrawManager;
import com.zurrtum.create.client.flywheel.backend.engine.GroupKey;
import com.zurrtum.create.client.flywheel.backend.engine.InstanceHandleImpl;
import com.zurrtum.create.client.flywheel.backend.engine.InstancerKey;
import com.zurrtum.create.client.flywheel.backend.engine.LightStorage;
import com.zurrtum.create.client.flywheel.backend.engine.MaterialEncoder;
import com.zurrtum.create.client.flywheel.backend.engine.MaterialRenderState;
import com.zurrtum.create.client.flywheel.backend.engine.MeshPool;
import com.zurrtum.create.client.flywheel.backend.engine.TextureBinder;
import com.zurrtum.create.client.flywheel.backend.engine.embed.Environment;
import com.zurrtum.create.client.flywheel.backend.engine.embed.EnvironmentStorage;
import com.zurrtum.create.client.flywheel.backend.engine.indirect.OitFramebuffer;
import com.zurrtum.create.client.flywheel.backend.engine.instancing.InstancedDraw;
import com.zurrtum.create.client.flywheel.backend.engine.instancing.InstancedInstancer;
import com.zurrtum.create.client.flywheel.backend.engine.instancing.InstancedLight;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.Uniforms;
import com.zurrtum.create.client.flywheel.backend.gl.TextureBuffer;
import com.zurrtum.create.client.flywheel.backend.gl.array.GlVertexArray;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.Identifier;

public class InstancedDrawManager
extends DrawManager<InstancedInstancer<?>> {
    private static final Comparator<InstancedDraw> DRAW_COMPARATOR = Comparator.comparingInt(InstancedDraw::bias).thenComparingInt(InstancedDraw::indexOfMeshInModel).thenComparing(InstancedDraw::material, MaterialRenderState.COMPARATOR);
    private final List<InstancedDraw> allDraws = new ArrayList<InstancedDraw>();
    private boolean needSort = false;
    private final List<InstancedDraw> draws = new ArrayList<InstancedDraw>();
    private final List<InstancedDraw> oitDraws = new ArrayList<InstancedDraw>();
    private final InstancingPrograms programs;
    private final MeshPool meshPool;
    private final GlVertexArray vao;
    private final TextureBuffer instanceTexture;
    private final InstancedLight light;
    private final OitFramebuffer oitFramebuffer;

    public InstancedDrawManager(InstancingPrograms programs) {
        programs.acquire();
        this.programs = programs;
        this.meshPool = new MeshPool();
        this.vao = GlVertexArray.create();
        this.instanceTexture = new TextureBuffer();
        this.light = new InstancedLight();
        this.meshPool.bind(this.vao);
        this.oitFramebuffer = new OitFramebuffer(programs.oitPrograms());
    }

    @Override
    public void render(LightStorage lightStorage, EnvironmentStorage environmentStorage) {
        super.render(lightStorage, environmentStorage);
        this.instancers.values().removeIf(instancer -> {
            if (instancer.instanceCount() == 0) {
                instancer.delete();
                return true;
            }
            instancer.updateBuffer();
            return false;
        });
        this.needSort |= this.allDraws.removeIf(InstancedDraw::deleted);
        if (this.needSort) {
            this.allDraws.sort(DRAW_COMPARATOR);
            this.draws.clear();
            this.oitDraws.clear();
            for (InstancedDraw draw : this.allDraws) {
                if (draw.material().transparency() == Transparency.ORDER_INDEPENDENT) {
                    this.oitDraws.add(draw);
                    continue;
                }
                this.draws.add(draw);
            }
            this.needSort = false;
        }
        this.meshPool.flush();
        this.light.flush(lightStorage);
        if (this.allDraws.isEmpty()) {
            return;
        }
        Uniforms.bindAll();
        this.vao.bindForDraw();
        TextureBinder.bindLightAndOverlay();
        this.light.bind();
        MaterialRenderState.setupFrameBuffer();
        this.submitDraws();
        if (!this.oitDraws.isEmpty()) {
            this.oitFramebuffer.prepare();
            this.oitFramebuffer.depthRange();
            this.submitOitDraws(PipelineCompiler.OitMode.DEPTH_RANGE);
            this.oitFramebuffer.renderTransmittance();
            this.submitOitDraws(PipelineCompiler.OitMode.GENERATE_COEFFICIENTS);
            this.oitFramebuffer.renderDepthFromTransmittance();
            this.vao.bindForDraw();
            this.oitFramebuffer.accumulate();
            this.submitOitDraws(PipelineCompiler.OitMode.EVALUATE);
            this.oitFramebuffer.composite();
        }
        MaterialRenderState.reset();
        TextureBinder.resetLightAndOverlay();
    }

    private void submitDraws() {
        for (InstancedDraw drawCall : this.draws) {
            Material material = drawCall.material();
            GroupKey<?> groupKey = drawCall.groupKey;
            Environment environment = groupKey.environment();
            GlProgram program = this.programs.get(groupKey.instanceType(), environment.contextShader(), material, PipelineCompiler.OitMode.OFF);
            program.bind();
            environment.setupDraw(program);
            InstancedDrawManager.uploadMaterialUniform(program, material);
            program.setUInt("_flw_vertexOffset", drawCall.mesh().baseVertex());
            MaterialRenderState.setup(material);
            Samplers.INSTANCE_BUFFER.makeActive();
            drawCall.render(this.instanceTexture);
        }
    }

    private void submitOitDraws(PipelineCompiler.OitMode mode) {
        for (InstancedDraw drawCall : this.oitDraws) {
            Material material = drawCall.material();
            GroupKey<?> groupKey = drawCall.groupKey;
            Environment environment = groupKey.environment();
            GlProgram program = this.programs.get(groupKey.instanceType(), environment.contextShader(), material, mode);
            program.bind();
            environment.setupDraw(program);
            InstancedDrawManager.uploadMaterialUniform(program, material);
            program.setUInt("_flw_vertexOffset", drawCall.mesh().baseVertex());
            MaterialRenderState.setupOit(material);
            Samplers.INSTANCE_BUFFER.makeActive();
            drawCall.render(this.instanceTexture);
        }
    }

    @Override
    public void delete() {
        this.instancers.values().forEach(InstancedInstancer::delete);
        this.allDraws.forEach(InstancedDraw::delete);
        this.allDraws.clear();
        this.draws.clear();
        this.oitDraws.clear();
        this.meshPool.delete();
        this.instanceTexture.delete();
        this.programs.release();
        this.vao.delete();
        this.light.delete();
        this.oitFramebuffer.delete();
        super.delete();
    }

    @Override
    protected <I extends Instance> InstancedInstancer<I> create(InstancerKey<I> key) {
        return new InstancedInstancer<I>(key, new AbstractInstancer.Recreate<I>(key, this));
    }

    @Override
    protected <I extends Instance> void initialize(InstancerKey<I> key, InstancedInstancer<?> instancer) {
        instancer.init();
        List<Model.ConfiguredMesh> meshes = key.model().meshes();
        for (int i = 0; i < meshes.size(); ++i) {
            Model.ConfiguredMesh entry = meshes.get(i);
            MeshPool.PooledMesh mesh = this.meshPool.alloc(entry.mesh());
            GroupKey<I> groupKey = new GroupKey<I>(key.type(), key.environment());
            InstancedDraw instancedDraw = new InstancedDraw(instancer, mesh, groupKey, entry.material(), key.bias(), i);
            this.allDraws.add(instancedDraw);
            this.needSort = true;
            instancer.addDrawCall(instancedDraw);
        }
    }

    @Override
    public void renderCrumbling(List<Engine.CrumblingBlock> crumblingBlocks) {
        Map<GroupKey<?>, Int2ObjectMap<List<Pair<InstancedInstancer, InstanceHandleImpl<?>>>>> byType = InstancedDrawManager.doCrumblingSort(crumblingBlocks, handle -> {
            if (handle instanceof InstancedInstancer) {
                InstancedInstancer instancer = (InstancedInstancer)handle;
                return instancer;
            }
            return null;
        });
        if (byType.isEmpty()) {
            return;
        }
        SimpleMaterial.Builder crumblingMaterial = SimpleMaterial.builder();
        Uniforms.bindAll();
        this.vao.bindForDraw();
        TextureBinder.bindLightAndOverlay();
        MaterialRenderState.setupFrameBuffer();
        for (Map.Entry<GroupKey<?>, Int2ObjectMap<List<Pair<InstancedInstancer, InstanceHandleImpl<?>>>>> groupEntry : byType.entrySet()) {
            Int2ObjectMap<List<Pair<InstancedInstancer, InstanceHandleImpl<?>>>> byProgress = groupEntry.getValue();
            GroupKey<?> shader = groupEntry.getKey();
            for (Int2ObjectMap.Entry progressEntry : byProgress.int2ObjectEntrySet()) {
                TextureBinder.bindCrumbling((Identifier)ModelBakery.BREAKING_LOCATIONS.get(progressEntry.getIntKey()));
                for (Pair instanceHandlePair : (List)progressEntry.getValue()) {
                    InstancedInstancer instancer = (InstancedInstancer)instanceHandlePair.getFirst();
                    int index = ((InstanceHandleImpl)instanceHandlePair.getSecond()).index;
                    for (InstancedDraw draw : instancer.draws()) {
                        CommonCrumbling.applyCrumblingProperties(crumblingMaterial, draw.material());
                        GlProgram program = this.programs.get(shader.instanceType(), ContextShader.CRUMBLING, crumblingMaterial, PipelineCompiler.OitMode.OFF);
                        program.bind();
                        program.setInt("_flw_baseInstance", index);
                        InstancedDrawManager.uploadMaterialUniform(program, crumblingMaterial);
                        MaterialRenderState.setup(crumblingMaterial);
                        Samplers.INSTANCE_BUFFER.makeActive();
                        draw.renderOne(this.instanceTexture);
                    }
                }
            }
        }
        MaterialRenderState.reset();
        TextureBinder.resetLightAndOverlay();
    }

    @Override
    public void triggerFallback() {
        InstancingPrograms.kill();
        Minecraft.getInstance().levelRenderer.allChanged();
    }

    public static void uploadMaterialUniform(GlProgram program, Material material) {
        int packedFogAndCutout = MaterialEncoder.packUberShader(material);
        int packedMaterialProperties = MaterialEncoder.packProperties(material);
        program.setUVec2("_flw_packedMaterial", packedFogAndCutout, packedMaterialProperties);
    }
}

