/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformWriter;
import org.joml.Vector4f;

public final class FogUniforms
extends UniformWriter {
    private static final int SIZE = 32;
    static final UniformBuffer BUFFER = new UniformBuffer(1, 32);
    static final float[] CACHE = new float[8];

    public static void update(Vector4f fogColor, float environmentalStart, float environmentalEnd, float renderDistanceStart, float renderDistanceEnd) {
        FogUniforms.CACHE[0] = fogColor.x;
        FogUniforms.CACHE[1] = fogColor.y;
        FogUniforms.CACHE[2] = fogColor.z;
        FogUniforms.CACHE[3] = fogColor.w;
        FogUniforms.CACHE[4] = environmentalStart;
        FogUniforms.CACHE[5] = environmentalEnd;
        FogUniforms.CACHE[6] = renderDistanceStart;
        FogUniforms.CACHE[7] = renderDistanceEnd;
    }

    public static void update(GpuBufferSlice shaderFog) {
        long ptr = BUFFER.ptr();
        if (shaderFog.buffer().usage() == 128) {
            ptr = FogUniforms.writeFloat(ptr, 0.0f);
            ptr = FogUniforms.writeFloat(ptr, 0.0f);
            ptr = FogUniforms.writeFloat(ptr, 0.0f);
            ptr = FogUniforms.writeFloat(ptr, 0.0f);
            ptr = FogUniforms.writeFloat(ptr, Float.MAX_VALUE);
            ptr = FogUniforms.writeFloat(ptr, Float.MAX_VALUE);
            ptr = FogUniforms.writeFloat(ptr, Float.MAX_VALUE);
            ptr = FogUniforms.writeFloat(ptr, Float.MAX_VALUE);
        } else {
            ptr = FogUniforms.writeFloat(ptr, CACHE[0]);
            ptr = FogUniforms.writeFloat(ptr, CACHE[1]);
            ptr = FogUniforms.writeFloat(ptr, CACHE[2]);
            ptr = FogUniforms.writeFloat(ptr, CACHE[3]);
            ptr = FogUniforms.writeFloat(ptr, CACHE[4]);
            ptr = FogUniforms.writeFloat(ptr, CACHE[5]);
            ptr = FogUniforms.writeFloat(ptr, CACHE[6]);
            ptr = FogUniforms.writeFloat(ptr, CACHE[7]);
        }
        BUFFER.markDirty();
    }
}

