/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.backend.FlwBackendXplat;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformBuffer;
import com.zurrtum.create.client.flywheel.backend.engine.uniform.UniformWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.ARGB;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public final class PlayerUniforms
extends UniformWriter {
    private static final int SIZE = 76;
    static final UniformBuffer BUFFER = new UniformBuffer(3, 76);

    private PlayerUniforms() {
    }

    public static void update(RenderContext context) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            BUFFER.clear();
            return;
        }
        long ptr = BUFFER.ptr();
        PlayerInfo info = player.getPlayerInfo();
        Vec3 eyePos = player.getEyePosition(context.partialTick());
        ptr = PlayerUniforms.writeVec3(ptr, (float)eyePos.x, (float)eyePos.y, (float)eyePos.z);
        ptr = PlayerUniforms.writeTeamColor(ptr, info == null ? null : info.getTeam());
        ptr = PlayerUniforms.writeEyeBrightness(ptr, player);
        ptr = PlayerUniforms.writeHeldLight(ptr, player);
        ptr = PlayerUniforms.writeEyeIn(ptr, player);
        ptr = PlayerUniforms.writeInt(ptr, player.isCrouching() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.isSleeping() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.isSwimming() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.isFallFlying() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, player.isShiftKeyDown() ? 1 : 0);
        ptr = PlayerUniforms.writeInt(ptr, info == null ? 0 : info.getGameMode().getId());
        BUFFER.markDirty();
    }

    private static long writeTeamColor(long ptr, @Nullable PlayerTeam team) {
        if (team != null) {
            Integer color = team.getColor().getColor();
            if (color != null) {
                int red = ARGB.red((int)color);
                int green = ARGB.green((int)color);
                int blue = ARGB.blue((int)color);
                return PlayerUniforms.writeVec4(ptr, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
            }
            return PlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return PlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    private static long writeEyeBrightness(long ptr, LocalPlayer player) {
        Level level = player.level();
        int blockBrightness = level.getBrightness(LightLayer.BLOCK, player.blockPosition());
        int skyBrightness = level.getBrightness(LightLayer.SKY, player.blockPosition());
        int maxBrightness = 15;
        return PlayerUniforms.writeVec2(ptr, (float)blockBrightness / (float)maxBrightness, (float)skyBrightness / (float)maxBrightness);
    }

    private static long writeHeldLight(long ptr, LocalPlayer player) {
        int heldLight = 0;
        for (InteractionHand hand : InteractionHand.values()) {
            BlockItem blockItem;
            Block block;
            int blockLight;
            Item handItem = player.getItemInHand(hand).getItem();
            if (!(handItem instanceof BlockItem) || heldLight >= (blockLight = FlwBackendXplat.INSTANCE.getLightEmission((block = (blockItem = (BlockItem)handItem).getBlock()).defaultBlockState(), (BlockGetter)player.level(), player.blockPosition()))) continue;
            heldLight = blockLight;
        }
        return PlayerUniforms.writeFloat(ptr, (float)heldLight / 15.0f);
    }

    private static long writeEyeIn(long ptr, LocalPlayer player) {
        Level level = player.level();
        Vec3 eyePos = player.getEyePosition();
        BlockPos blockPos = BlockPos.containing((Position)eyePos);
        return PlayerUniforms.writeInFluidAndBlock(ptr, level, blockPos, eyePos);
    }
}

