/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.zurrtum.create.client.flywheel.lib.util.ExtraMemoryOps;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

class UniformWriter {
    UniformWriter() {
    }

    static long writeInt(long ptr, int value) {
        MemoryUtil.memPutInt((long)ptr, (int)value);
        return ptr + 4L;
    }

    static long writeFloat(long ptr, float value) {
        MemoryUtil.memPutFloat((long)ptr, (float)value);
        return ptr + 4L;
    }

    static long writeVec2(long ptr, float x, float y) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        return ptr + 8L;
    }

    static long writeVec3(long ptr, float x, float y, float z) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)0.0f);
        return ptr + 16L;
    }

    static long writeVec3(long ptr, Vector3fc vec) {
        return UniformWriter.writeVec3(ptr, vec.x(), vec.y(), vec.z());
    }

    static long writeVec4(long ptr, float x, float y, float z, float w) {
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)w);
        return ptr + 16L;
    }

    static long writeIVec2(long ptr, int x, int y) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        return ptr + 8L;
    }

    static long writeIVec3(long ptr, int x, int y, int z) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)0);
        return ptr + 16L;
    }

    static long writeIVec4(long ptr, int x, int y, int z, int w) {
        MemoryUtil.memPutInt((long)ptr, (int)x);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)y);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)z);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)w);
        return ptr + 16L;
    }

    static long writeMat4(long ptr, Matrix4f mat) {
        ExtraMemoryOps.putMatrix4f(ptr, (Matrix4fc)mat);
        return ptr + 64L;
    }

    static long writeInFluidAndBlock(long ptr, Level level, BlockPos blockPos, Vec3 pos) {
        FluidState fluidState = level.getFluidState(blockPos);
        BlockState blockState = level.getBlockState(blockPos);
        float height = fluidState.getHeight((BlockGetter)level, blockPos);
        if (fluidState.isEmpty()) {
            MemoryUtil.memPutInt((long)ptr, (int)0);
        } else if (pos.y < (double)((float)blockPos.getY() + height)) {
            if (fluidState.is(FluidTags.WATER)) {
                MemoryUtil.memPutInt((long)ptr, (int)1);
            } else if (fluidState.is(FluidTags.LAVA)) {
                MemoryUtil.memPutInt((long)ptr, (int)2);
            } else {
                MemoryUtil.memPutInt((long)ptr, (int)-1);
            }
        }
        if (blockState.isAir()) {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        } else if (blockState.is(Blocks.POWDER_SNOW)) {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)0);
        } else {
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)-1);
        }
        return ptr + 8L;
    }
}

