/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.gl.array;

import com.zurrtum.create.client.flywheel.backend.gl.GlCompat;
import com.zurrtum.create.client.flywheel.backend.gl.GlStateTracker;
import com.zurrtum.create.client.flywheel.backend.gl.array.GlVertexArray;
import com.zurrtum.create.client.flywheel.backend.gl.array.VertexAttribute;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBufferType;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import net.minecraft.util.Util;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;

public class GlVertexArraySeparateAttributes
extends GlVertexArray {
    public static final boolean SUPPORTED = GlVertexArraySeparateAttributes.isSupported();
    private final BitSet attributeEnabled = new BitSet(MAX_ATTRIBS);
    private final VertexAttribute[] attributes = new VertexAttribute[MAX_ATTRIBS];
    private final int[] attributeBindings = (int[])Util.make((Object)new int[MAX_ATTRIBS], a -> Arrays.fill(a, -1));
    private final int[] bindingBuffers = new int[16];
    private final long[] bindingOffsets = new long[16];
    private final int[] bindingStrides = new int[16];
    private final int[] bindingDivisors = new int[16];
    private int elementBufferBinding = 0;

    public GlVertexArraySeparateAttributes() {
        this.handle(GL43C.glGenVertexArrays());
    }

    @Override
    public void bindVertexBuffer(int bindingIndex, int vbo, long offset, int stride) {
        if (this.bindingBuffers[bindingIndex] != vbo || this.bindingOffsets[bindingIndex] != offset || this.bindingStrides[bindingIndex] != stride) {
            GlStateTracker.bindVao(this.handle());
            GL43C.glBindVertexBuffer((int)bindingIndex, (int)vbo, (long)offset, (int)stride);
            this.bindingBuffers[bindingIndex] = vbo;
            this.bindingOffsets[bindingIndex] = offset;
            this.bindingStrides[bindingIndex] = stride;
        }
    }

    @Override
    public void setBindingDivisor(int bindingIndex, int divisor) {
        if (this.bindingDivisors[bindingIndex] != divisor) {
            GL43C.glVertexBindingDivisor((int)bindingIndex, (int)divisor);
            this.bindingDivisors[bindingIndex] = divisor;
        }
    }

    @Override
    public void bindAttributes(int bindingIndex, int startAttribIndex, List<VertexAttribute> vertexAttributes) {
        GlStateTracker.bindVao(this.handle());
        int attribIndex = startAttribIndex;
        int offset = 0;
        for (VertexAttribute attribute : vertexAttributes) {
            if (!this.attributeEnabled.get(attribIndex)) {
                GL43C.glEnableVertexAttribArray((int)attribIndex);
                this.attributeEnabled.set(attribIndex);
            }
            if (!attribute.equals(this.attributes[attribIndex])) {
                if (attribute instanceof VertexAttribute.Float) {
                    VertexAttribute.Float f = (VertexAttribute.Float)attribute;
                    GL43C.glVertexAttribFormat((int)attribIndex, (int)f.size(), (int)f.type().glEnum, (boolean)f.normalized(), (int)offset);
                } else if (attribute instanceof VertexAttribute.Int) {
                    VertexAttribute.Int vi = (VertexAttribute.Int)attribute;
                    GL43C.glVertexAttribIFormat((int)attribIndex, (int)vi.size(), (int)vi.type().glEnum, (int)offset);
                }
                this.attributes[attribIndex] = attribute;
            }
            if (this.attributeBindings[attribIndex] != bindingIndex) {
                GL43C.glVertexAttribBinding((int)attribIndex, (int)bindingIndex);
                this.attributeBindings[attribIndex] = bindingIndex;
            }
            ++attribIndex;
            offset += attribute.byteWidth();
        }
    }

    @Override
    public void setElementBuffer(int ebo) {
        if (this.elementBufferBinding != ebo) {
            GlStateTracker.bindVao(this.handle());
            GlBufferType.ELEMENT_ARRAY_BUFFER.bind(ebo);
            this.elementBufferBinding = ebo;
        }
    }

    private static boolean isSupported() {
        GLCapabilities c = GlCompat.CAPABILITIES;
        return Checks.checkFunctions((long[])new long[]{c.glBindVertexBuffer, c.glVertexBindingDivisor, c.glEnableVertexAttribArray, c.glVertexAttribFormat, c.glVertexAttribIFormat, c.glVertexAttribBinding});
    }
}

