/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.gl.buffer;

import com.zurrtum.create.client.flywheel.backend.gl.GlCompat;
import com.zurrtum.create.client.flywheel.backend.gl.buffer.GlBufferType;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;

public interface Buffer {
    public static final Buffer IMPL = new DSA().fallback();

    public int create();

    public void data(int var1, long var2, long var4, int var6);

    public void subData(int var1, long var2, long var4, long var6);

    public static class DSA
    implements Buffer {
        @Override
        public int create() {
            return GL45C.glCreateBuffers();
        }

        @Override
        public void data(int vbo, long size, long ptr, int glEnum) {
            GL45C.nglNamedBufferData((int)vbo, (long)size, (long)ptr, (int)glEnum);
        }

        @Override
        public void subData(int vbo, long offset, long size, long ptr) {
            GL45C.nglNamedBufferSubData((int)vbo, (long)offset, (long)size, (long)ptr);
        }

        public Buffer fallback() {
            if (DSA.dsaMethodsAvailable()) {
                return this;
            }
            return new Core();
        }

        private static boolean dsaMethodsAvailable() {
            GLCapabilities c = GlCompat.CAPABILITIES;
            return Checks.checkFunctions((long[])new long[]{c.glCreateBuffers, c.glNamedBufferData, c.glCopyNamedBufferSubData, c.glMapNamedBufferRange, c.glUnmapNamedBuffer});
        }
    }

    public static class Core
    implements Buffer {
        @Override
        public int create() {
            return GL15.glGenBuffers();
        }

        @Override
        public void data(int vbo, long size, long ptr, int glEnum) {
            GlBufferType.COPY_WRITE_BUFFER.bind(vbo);
            GL15.nglBufferData((int)GlBufferType.COPY_WRITE_BUFFER.glEnum, (long)size, (long)ptr, (int)glEnum);
        }

        @Override
        public void subData(int vbo, long offset, long size, long ptr) {
            GlBufferType.COPY_WRITE_BUFFER.bind(vbo);
            GL15.nglBufferSubData((int)GlBufferType.COPY_WRITE_BUFFER.glEnum, (long)offset, (long)size, (long)ptr);
        }
    }
}

