/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl;

import com.zurrtum.create.client.flywheel.backend.compile.FlwPrograms;
import com.zurrtum.create.client.flywheel.backend.glsl.LoadError;
import com.zurrtum.create.client.flywheel.backend.glsl.LoadResult;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceFile;
import com.zurrtum.create.client.flywheel.lib.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.VisibleForTesting;

public class ShaderSources {
    public static final String SHADER_DIR = "flywheel/";
    @VisibleForTesting
    protected final Map<Identifier, LoadResult> cache;

    public ShaderSources(ResourceManager manager) {
        SourceFinder sourceFinder = new SourceFinder(manager);
        long loadStart = System.nanoTime();
        manager.listResources("flywheel", ShaderSources::isShader).forEach(sourceFinder::rootLoad);
        long loadEnd = System.nanoTime();
        FlwPrograms.LOGGER.info("Loaded {} shader sources in {}", (Object)sourceFinder.results.size(), (Object)StringUtil.formatTime(loadEnd - loadStart));
        this.cache = sourceFinder.results;
    }

    private static Identifier locationWithoutFlywheelPrefix(Identifier loc) {
        return Identifier.fromNamespaceAndPath((String)loc.getNamespace(), (String)loc.getPath().substring(SHADER_DIR.length()));
    }

    public LoadResult find(Identifier location) {
        return this.cache.computeIfAbsent(location, loc -> new LoadResult.Failure(new LoadError.ResourceError((Identifier)loc)));
    }

    public SourceFile get(Identifier location) {
        return this.find(location).unwrap();
    }

    private static boolean isShader(Identifier loc) {
        String path = loc.getPath();
        return path.endsWith(".glsl") || path.endsWith(".vert") || path.endsWith(".frag") || path.endsWith(".comp");
    }

    private static class SourceFinder {
        private final Deque<Identifier> findStack = new ArrayDeque<Identifier>();
        private final Map<Identifier, LoadResult> results = new HashMap<Identifier, LoadResult>();
        private final ResourceManager manager;

        public SourceFinder(ResourceManager manager) {
            this.manager = manager;
        }

        public void rootLoad(Identifier loc, Resource resource) {
            Identifier strippedLoc = ShaderSources.locationWithoutFlywheelPrefix(loc);
            if (this.results.containsKey(strippedLoc)) {
                return;
            }
            this.results.put(strippedLoc, this.readResource(strippedLoc, resource));
        }

        public LoadResult recursiveLoad(Identifier location) {
            if (this.findStack.contains(location)) {
                this.findStack.addLast(location);
                List<Identifier> copy = List.copyOf(this.findStack);
                this.findStack.removeLast();
                return new LoadResult.Failure(new LoadError.CircularDependency(location, copy));
            }
            this.findStack.addLast(location);
            LoadResult out = this._find(location);
            this.findStack.removeLast();
            return out;
        }

        private LoadResult _find(Identifier location) {
            LoadResult out = this.results.get(location);
            if (out == null) {
                out = this.load(location);
                this.results.put(location, out);
            }
            return out;
        }

        private LoadResult load(Identifier loc) {
            return this.manager.getResource(loc.withPrefix(ShaderSources.SHADER_DIR)).map(resource -> this.readResource(loc, (Resource)resource)).orElseGet(() -> new LoadResult.Failure(new LoadError.ResourceError(loc)));
        }

        private LoadResult readResource(Identifier loc, Resource resource) {
            LoadResult loadResult;
            block8: {
                InputStream stream = resource.open();
                try {
                    String sourceString = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    loadResult = SourceFile.parse(this::recursiveLoad, loc, sourceString);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return new LoadResult.Failure(new LoadError.IOError(loc, e));
                    }
                }
                stream.close();
            }
            return loadResult;
        }
    }
}

