/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.client.flywheel.backend.glsl.Import;
import com.zurrtum.create.client.flywheel.backend.glsl.LoadError;
import com.zurrtum.create.client.flywheel.backend.glsl.LoadResult;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceComponent;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceLines;
import com.zurrtum.create.client.flywheel.backend.glsl.span.Span;
import com.zurrtum.create.client.flywheel.backend.glsl.span.StringSpan;
import com.zurrtum.create.client.flywheel.lib.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.IdentifierException;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Nullable;

public class SourceFile
implements SourceComponent {
    public final Identifier name;
    public final SourceLines source;
    public final ImmutableList<Import> imports;
    public final List<SourceFile> included;
    public final String finalSource;

    private SourceFile(Identifier name, SourceLines source, ImmutableList<Import> imports, List<SourceFile> included, String finalSource) {
        this.name = name;
        this.source = source;
        this.imports = imports;
        this.included = included;
        this.finalSource = finalSource;
    }

    public static LoadResult empty(Identifier name) {
        return new LoadResult.Success(new SourceFile(name, new SourceLines(name, ""), (ImmutableList<Import>)ImmutableList.of(), (List<SourceFile>)ImmutableList.of(), ""));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoadResult parse(Function<Identifier, LoadResult> sourceFinder, Identifier name, String stringSource) {
        SourceLines source = new SourceLines(name, stringSource);
        ImmutableList<Import> imports = Import.parseImports(source);
        ArrayList<SourceFile> included = new ArrayList<SourceFile>();
        ArrayList<Pair<Span, LoadError>> failures = new ArrayList<Pair<Span, LoadError>>();
        HashSet<String> seen = new HashSet<String>();
        for (Import i : imports) {
            Identifier location;
            Span fileSpan = i.file();
            String string = fileSpan.toString();
            if (!seen.add(string)) continue;
            try {
                location = ResourceUtil.parseFlywheelDefault(string);
            }
            catch (IdentifierException e) {
                failures.add((Pair<Span, LoadError>)Pair.of((Object)fileSpan, (Object)new LoadError.MalformedInclude(e)));
                continue;
            }
            LoadResult result = sourceFinder.apply(location);
            if (result instanceof LoadResult.Success) {
                LoadResult.Success s = (LoadResult.Success)result;
                included.add(s.unwrap());
                continue;
            }
            if (!(result instanceof LoadResult.Failure)) continue;
            LoadResult.Failure failure = (LoadResult.Failure)result;
            try {
                LoadError loadError;
                LoadError error = loadError = failure.error();
                failures.add((Pair<Span, LoadError>)Pair.of((Object)fileSpan, (Object)error));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        if (!failures.isEmpty()) {
            return new LoadResult.Failure(new LoadError.IncludeError(name, failures));
        }
        String finalSource = SourceFile.generateFinalSource(imports, source);
        return new LoadResult.Success(new SourceFile(name, source, imports, included, finalSource));
    }

    @Override
    public Collection<? extends SourceComponent> included() {
        return this.included;
    }

    @Override
    public String source() {
        return this.finalSource;
    }

    @Override
    public String name() {
        return this.name.toString();
    }

    public Span getLineSpanNoWhitespace(int line) {
        int begin;
        int end = begin + this.source.lineString(line).length();
        for (begin = this.source.lineStartIndex(line); begin < end && Character.isWhitespace(this.source.charAt(begin)); ++begin) {
        }
        return new StringSpan(this.source, begin, end);
    }

    public Span getLineSpanMatching(int line, @Nullable String match) {
        if (match == null) {
            return this.getLineSpanNoWhitespace(line);
        }
        int spanBegin = this.source.lineString(line).indexOf(match);
        if (spanBegin == -1) {
            return this.getLineSpanNoWhitespace(line);
        }
        int begin = this.source.lineStartIndex(line) + spanBegin;
        int end = begin + match.length();
        return new StringSpan(this.source, begin, end);
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    private static String generateFinalSource(ImmutableList<Import> imports, SourceLines source) {
        StringBuilder out = new StringBuilder();
        int lastEnd = 0;
        for (Import include : imports) {
            Span loc = include.self();
            out.append(source, lastEnd, loc.startIndex());
            lastEnd = loc.endIndex();
        }
        out.append(source, lastEnd, source.length());
        return out.toString();
    }
}

