/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl.generate;

import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslExpr;

public interface GlslStmt {
    public static final GlslStmt BREAK = () -> "break;";
    public static final GlslStmt CONTINUE = () -> "continue;";
    public static final GlslStmt RETURN = () -> "return;";

    public static GlslStmt eval(GlslExpr expr) {
        return new Eval(expr);
    }

    public static GlslStmt ret(GlslExpr value) {
        return new Return(value);
    }

    public static GlslStmt raw(String s) {
        return new Raw(s);
    }

    public String prettyPrint();

    public record Eval(GlslExpr expr) implements GlslStmt
    {
        @Override
        public String prettyPrint() {
            return this.expr.prettyPrint() + ";";
        }
    }

    public record Return(GlslExpr expr) implements GlslStmt
    {
        @Override
        public String prettyPrint() {
            return "return " + this.expr.prettyPrint() + ";";
        }
    }

    public record Raw(String glsl) implements GlslStmt
    {
        @Override
        public String prettyPrint() {
            return this.glsl;
        }
    }
}

