/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl.layout;

import com.zurrtum.create.client.flywheel.api.layout.ElementType;
import com.zurrtum.create.client.flywheel.api.layout.Layout;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Unmodifiable;

final class LayoutImpl
implements Layout {
    private final @Unmodifiable List<Layout.Element> elements;
    private final @Unmodifiable Map<String, Layout.Element> map;
    private final int byteSize;
    private final int byteAlignment;

    LayoutImpl(@Unmodifiable List<Layout.Element> elements, int byteSize, int byteAlignment) {
        this.elements = elements;
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (Layout.Element element : this.elements) {
            map.put((Object)element.name(), (Object)element);
        }
        map.trim();
        this.map = Collections.unmodifiableMap(map);
        this.byteSize = byteSize;
        this.byteAlignment = byteAlignment;
    }

    @Override
    public @Unmodifiable List<Layout.Element> elements() {
        return this.elements;
    }

    @Override
    public @Unmodifiable Map<String, Layout.Element> asMap() {
        return this.map;
    }

    @Override
    public int byteSize() {
        return this.byteSize;
    }

    @Override
    public int byteAlignment() {
        return this.byteAlignment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.elements.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayoutImpl other = (LayoutImpl)obj;
        return this.elements.equals(other.elements);
    }

    record ElementImpl(String name, ElementType type, int byteOffset, int paddedByteSize, int paddingByteSize) implements Layout.Element
    {
    }
}

