/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl.layout;

import com.zurrtum.create.client.flywheel.api.layout.FloatRepr;
import com.zurrtum.create.client.flywheel.api.layout.MatrixElementType;
import org.jetbrains.annotations.Range;

record MatrixElementTypeImpl(FloatRepr repr, @Range(from=2L, to=4L) int rows, @Range(from=2L, to=4L) int columns, int byteSize, int byteAlignment) implements MatrixElementType
{
    static MatrixElementTypeImpl create(FloatRepr repr, @Range(from=2L, to=4L) int rows, @Range(from=2L, to=4L) int columns) {
        if (rows < 2 || rows > 4) {
            throw new IllegalArgumentException("Matrix element row count must be in range [2, 4]!");
        }
        if (columns < 2 || columns > 4) {
            throw new IllegalArgumentException("Matrix element column count must be in range [2, 4]!");
        }
        return new MatrixElementTypeImpl(repr, rows, columns, repr.byteSize() * rows * columns, repr.byteSize());
    }
}

