/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl.visualization.storage;

import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.impl.visualization.storage.Storage;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class BlockEntityStorage
extends Storage<BlockEntity> {
    private final Long2ObjectMap<BlockEntityVisual<?>> posLookup = new Long2ObjectOpenHashMap();

    @Nullable
    public BlockEntityVisual<?> visualAtPos(long pos) {
        return (BlockEntityVisual)this.posLookup.get(pos);
    }

    @Override
    public boolean willAccept(BlockEntity blockEntity) {
        if (blockEntity.isRemoved()) {
            return false;
        }
        if (!VisualizationHelper.canVisualize(blockEntity)) {
            return false;
        }
        Level level = blockEntity.getLevel();
        if (level == null) {
            return false;
        }
        if (level.isEmptyBlock(blockEntity.getBlockPos())) {
            return false;
        }
        BlockPos pos = blockEntity.getBlockPos();
        BlockGetter existingChunk = level.getChunkForCollisions(pos.getX() >> 4, pos.getZ() >> 4);
        return existingChunk != null;
    }

    @Nullable
    protected BlockEntityVisual<?> createRaw(VisualizationContext visualizationContext, BlockEntity obj, float partialTick) {
        BlockEntityVisualizer<BlockEntity> visualizer = VisualizationHelper.getVisualizer(obj);
        if (visualizer == null) {
            return null;
        }
        BlockEntityVisual<BlockEntity> visual = visualizer.createVisual(visualizationContext, obj, partialTick);
        BlockPos blockPos = obj.getBlockPos();
        this.posLookup.put(blockPos.asLong(), visual);
        return visual;
    }

    @Override
    public void remove(BlockEntity obj) {
        this.posLookup.remove(obj.getBlockPos().asLong());
        super.remove(obj);
    }

    @Override
    public void recreateAll(VisualizationContext visualizationContext, float partialTick) {
        this.posLookup.clear();
        super.recreateAll(visualizationContext, partialTick);
    }

    @Override
    public void invalidate() {
        this.posLookup.clear();
        super.invalidate();
    }
}

