/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl.visualization.storage;

import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.LightUpdatedVisual;
import com.zurrtum.create.client.flywheel.impl.visualization.storage.SectionTracker;
import com.zurrtum.create.client.flywheel.lib.task.Distribute;
import com.zurrtum.create.client.flywheel.lib.task.Synchronizer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class LightUpdatedVisualStorage {
    private static final long NEVER_UPDATED = Long.MIN_VALUE;
    private static final long INITIAL_UPDATE_ID = -9223372036854775807L;
    private final Map<LightUpdatedVisual, LongSet> visual2Sections = new WeakHashMap<LightUpdatedVisual, LongSet>();
    private final Long2ObjectMap<List<Updater>> section2Updaters = new Long2ObjectOpenHashMap();
    private final LongSet sectionsUpdatedThisFrame = new LongOpenHashSet();
    private final Queue<MovedVisual> movedVisuals = new ConcurrentLinkedQueue<MovedVisual>();
    private long updateId = -9223372036854775807L;

    public Plan<DynamicVisual.Context> plan() {
        return (taskExecutor, context, onCompletion) -> {
            this.processMoved();
            if (this.sectionsUpdatedThisFrame.isEmpty()) {
                onCompletion.run();
                return;
            }
            Synchronizer sync = new Synchronizer(this.sectionsUpdatedThisFrame.size(), () -> {
                this.sectionsUpdatedThisFrame.clear();
                onCompletion.run();
            });
            long updateId = this.getNextUpdateId();
            Updater.Context updaterContext = new Updater.Context(updateId, context.partialTick());
            LongIterator longIterator = this.sectionsUpdatedThisFrame.iterator();
            while (longIterator.hasNext()) {
                long section = (Long)longIterator.next();
                List updaters = (List)this.section2Updaters.get(section);
                if (updaters != null && !updaters.isEmpty()) {
                    taskExecutor.execute(() -> Distribute.tasks(taskExecutor, updaterContext, sync, updaters, Updater::updateLight));
                    continue;
                }
                sync.decrementAndEventuallyRun();
            }
        };
    }

    private void processMoved() {
        MovedVisual moved;
        while ((moved = this.movedVisuals.poll()) != null) {
            if (!this.remove(moved.visual)) continue;
            this.addInner(moved.visual, moved.tracker);
        }
    }

    private long getNextUpdateId() {
        long out = this.updateId++;
        if (this.updateId == Long.MIN_VALUE) {
            this.updateId = -9223372036854775807L;
        }
        return out;
    }

    public void add(LightUpdatedVisual visual, SectionTracker tracker) {
        MovedVisual moved = new MovedVisual(visual, tracker);
        tracker.addListener(() -> this.movedVisuals.add(moved));
        this.addInner(visual, tracker);
    }

    private void addInner(LightUpdatedVisual visual, SectionTracker tracker) {
        if (tracker.sections().isEmpty()) {
            this.visual2Sections.put(visual, LongSet.of());
            return;
        }
        LongSet sections = tracker.sections();
        this.visual2Sections.put(visual, sections);
        Updater updater = LightUpdatedVisualStorage.createUpdater(visual, sections.size());
        LongIterator longIterator = sections.iterator();
        while (longIterator.hasNext()) {
            long section = (Long)longIterator.next();
            ((List)this.section2Updaters.computeIfAbsent(section, $ -> new ObjectArrayList())).add(updater);
        }
    }

    public boolean remove(LightUpdatedVisual visual) {
        LongSet sections = this.visual2Sections.remove(visual);
        if (sections == null) {
            return false;
        }
        LongIterator longIterator = sections.iterator();
        while (longIterator.hasNext()) {
            long section = (Long)longIterator.next();
            List updaters = (List)this.section2Updaters.get(section);
            if (updaters == null) continue;
            updaters.remove(LightUpdatedVisualStorage.indexOfUpdater(updaters, visual));
        }
        return true;
    }

    public void onLightUpdate(long section) {
        this.sectionsUpdatedThisFrame.add(section);
    }

    public void clear() {
        this.visual2Sections.clear();
        this.section2Updaters.clear();
        this.sectionsUpdatedThisFrame.clear();
        this.movedVisuals.clear();
    }

    private static int indexOfUpdater(List<Updater> updaters, LightUpdatedVisual visual) {
        for (int i = 0; i < updaters.size(); ++i) {
            if (updaters.get(i).visual() != visual) continue;
            return i;
        }
        return -1;
    }

    private static Updater createUpdater(LightUpdatedVisual visual, int sectionCount) {
        if (sectionCount == 1) {
            return new Updater.Simple(visual);
        }
        return new Updater.Synced(visual, new AtomicLong(Long.MIN_VALUE));
    }

    private record MovedVisual(LightUpdatedVisual visual, SectionTracker tracker) {
    }

    private static sealed interface Updater {
        public void updateLight(Context var1);

        public LightUpdatedVisual visual();

        public record Context(long updateId, float partialTick) {
        }

        public record Synced(LightUpdatedVisual visual, AtomicLong updateId) implements Updater
        {
            @Override
            public void updateLight(Context ctx) {
                if (this.updateId.getAndSet(ctx.updateId) != ctx.updateId) {
                    this.visual.updateLight(ctx.partialTick);
                }
            }
        }

        public record Simple(LightUpdatedVisual visual) implements Updater
        {
            @Override
            public void updateLight(Context ctx) {
                this.visual.updateLight(ctx.partialTick);
            }
        }
    }
}

