/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.impl.visualization.storage;

import com.zurrtum.create.client.flywheel.api.task.Plan;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.LightUpdatedVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visual.ShaderLightVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visual.Visual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.impl.ImplDebugFlags;
import com.zurrtum.create.client.flywheel.impl.visualization.storage.LightUpdatedVisualStorage;
import com.zurrtum.create.client.flywheel.impl.visualization.storage.SectionTracker;
import com.zurrtum.create.client.flywheel.impl.visualization.storage.ShaderLightVisualStorage;
import com.zurrtum.create.client.flywheel.lib.task.ConditionalPlan;
import com.zurrtum.create.client.flywheel.lib.task.ForEachPlan;
import com.zurrtum.create.client.flywheel.lib.task.NestedPlan;
import com.zurrtum.create.client.flywheel.lib.task.PlanMap;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class Storage<T> {
    private final Map<T, Visual> visuals = new Reference2ObjectOpenHashMap();
    protected final PlanMap<DynamicVisual, DynamicVisual.Context> dynamicVisuals = new PlanMap();
    protected final PlanMap<TickableVisual, TickableVisual.Context> tickableVisuals = new PlanMap();
    protected final List<SimpleDynamicVisual> simpleDynamicVisuals = new ArrayList<SimpleDynamicVisual>();
    protected final List<SimpleTickableVisual> simpleTickableVisuals = new ArrayList<SimpleTickableVisual>();
    protected final LightUpdatedVisualStorage lightUpdatedVisuals = new LightUpdatedVisualStorage();
    protected final ShaderLightVisualStorage shaderLightVisuals = new ShaderLightVisualStorage();

    public Collection<Visual> getAllVisuals() {
        return this.visuals.values();
    }

    public Plan<DynamicVisual.Context> framePlan() {
        ConditionalPlan update = ConditionalPlan.on(() -> !ImplDebugFlags.PAUSE_UPDATES).then(NestedPlan.of(this.dynamicVisuals, ForEachPlan.of(() -> this.simpleDynamicVisuals, SimpleDynamicVisual::beginFrame)));
        return NestedPlan.of(this.lightUpdatedVisuals.plan(), update);
    }

    public Plan<TickableVisual.Context> tickPlan() {
        return ConditionalPlan.on(() -> !ImplDebugFlags.PAUSE_UPDATES).then(NestedPlan.of(this.tickableVisuals, ForEachPlan.of(() -> this.simpleTickableVisuals, SimpleTickableVisual::tick)));
    }

    public LightUpdatedVisualStorage lightUpdatedVisuals() {
        return this.lightUpdatedVisuals;
    }

    public ShaderLightVisualStorage shaderLightVisuals() {
        return this.shaderLightVisuals;
    }

    public abstract boolean willAccept(T var1);

    public void add(VisualizationContext visualizationContext, T obj, float partialTick) {
        Visual visual = this.visuals.get(obj);
        if (visual == null && (visual = this.createRaw(visualizationContext, obj, partialTick)) != null) {
            this.setup(visual, partialTick);
            this.visuals.put(obj, visual);
        }
    }

    public void remove(T obj) {
        Visual visual = this.visuals.remove(obj);
        if (visual == null) {
            return;
        }
        if (visual instanceof DynamicVisual) {
            DynamicVisual dynamic = (DynamicVisual)visual;
            if (visual instanceof SimpleDynamicVisual) {
                SimpleDynamicVisual simpleDynamic = (SimpleDynamicVisual)visual;
                this.simpleDynamicVisuals.remove(simpleDynamic);
            } else {
                this.dynamicVisuals.remove(dynamic);
            }
        }
        if (visual instanceof TickableVisual) {
            TickableVisual tickable = (TickableVisual)visual;
            if (visual instanceof SimpleTickableVisual) {
                SimpleTickableVisual simpleTickable = (SimpleTickableVisual)visual;
                this.simpleTickableVisuals.remove(simpleTickable);
            } else {
                this.tickableVisuals.remove(tickable);
            }
        }
        if (visual instanceof LightUpdatedVisual) {
            LightUpdatedVisual lightUpdated = (LightUpdatedVisual)visual;
            this.lightUpdatedVisuals.remove(lightUpdated);
        }
        if (visual instanceof ShaderLightVisual) {
            ShaderLightVisual shaderLight = (ShaderLightVisual)visual;
            this.shaderLightVisuals.remove(shaderLight);
        }
        visual.delete();
    }

    public void update(T obj, float partialTick) {
        Visual visual = this.visuals.get(obj);
        if (visual == null) {
            return;
        }
        visual.update(partialTick);
    }

    public void recreateAll(VisualizationContext visualizationContext, float partialTick) {
        this.dynamicVisuals.clear();
        this.tickableVisuals.clear();
        this.simpleDynamicVisuals.clear();
        this.simpleTickableVisuals.clear();
        this.lightUpdatedVisuals.clear();
        this.shaderLightVisuals.clear();
        this.visuals.replaceAll((obj, visual) -> {
            visual.delete();
            Visual out = this.createRaw(visualizationContext, obj, partialTick);
            if (out != null) {
                this.setup(out, partialTick);
            }
            return out;
        });
    }

    @Nullable
    protected abstract Visual createRaw(VisualizationContext var1, T var2, float var3);

    private void setup(Visual visual, float partialTick) {
        if (visual instanceof DynamicVisual) {
            DynamicVisual dynamic = (DynamicVisual)visual;
            if (visual instanceof SimpleDynamicVisual) {
                SimpleDynamicVisual simpleDynamic = (SimpleDynamicVisual)visual;
                this.simpleDynamicVisuals.add(simpleDynamic);
            } else {
                this.dynamicVisuals.add(dynamic, dynamic.planFrame());
            }
        }
        if (visual instanceof TickableVisual) {
            TickableVisual tickable = (TickableVisual)visual;
            if (visual instanceof SimpleTickableVisual) {
                SimpleTickableVisual simpleTickable = (SimpleTickableVisual)visual;
                this.simpleTickableVisuals.add(simpleTickable);
            } else {
                this.tickableVisuals.add(tickable, tickable.planTick());
            }
        }
        if (visual instanceof SectionTrackedVisual) {
            SectionTrackedVisual tracked = (SectionTrackedVisual)visual;
            SectionTracker tracker = new SectionTracker();
            tracked.setSectionCollector(tracker);
            if (visual instanceof LightUpdatedVisual) {
                LightUpdatedVisual lightUpdated = (LightUpdatedVisual)visual;
                this.lightUpdatedVisuals.add(lightUpdated, tracker);
                lightUpdated.updateLight(partialTick);
            }
            if (visual instanceof ShaderLightVisual) {
                ShaderLightVisual shaderLight = (ShaderLightVisual)visual;
                this.shaderLightVisuals.add(shaderLight, tracker);
            }
        }
    }

    public void invalidate() {
        this.dynamicVisuals.clear();
        this.tickableVisuals.clear();
        this.simpleDynamicVisuals.clear();
        this.simpleTickableVisuals.clear();
        this.lightUpdatedVisuals.clear();
        this.shaderLightVisuals.clear();
        this.visuals.values().forEach(Visual::delete);
        this.visuals.clear();
    }
}

