/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.instance;

import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.lib.instance.AbstractInstance;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import net.minecraft.util.ARGB;

public abstract class ColoredLitInstance
extends AbstractInstance
implements FlatLit {
    public byte red = (byte)-1;
    public byte green = (byte)-1;
    public byte blue = (byte)-1;
    public byte alpha = (byte)-1;
    public int light = 0;

    public ColoredLitInstance(InstanceType<? extends ColoredLitInstance> type, InstanceHandle handle) {
        super(type, handle);
    }

    public ColoredLitInstance colorArgb(int argb) {
        return this.color(ARGB.red((int)argb), ARGB.green((int)argb), ARGB.blue((int)argb), ARGB.alpha((int)argb));
    }

    public ColoredLitInstance colorRgb(int rgb) {
        return this.color(ARGB.red((int)rgb), ARGB.green((int)rgb), ARGB.blue((int)rgb));
    }

    public ColoredLitInstance color(int red, int green, int blue, int alpha) {
        return this.color((byte)red, (byte)green, (byte)blue, (byte)alpha);
    }

    public ColoredLitInstance color(int red, int green, int blue) {
        return this.color((byte)red, (byte)green, (byte)blue);
    }

    public ColoredLitInstance color(byte red, byte green, byte blue, byte alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public ColoredLitInstance color(byte red, byte green, byte blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        return this;
    }

    public ColoredLitInstance color(float red, float green, float blue, float alpha) {
        return this.color((byte)(red * 255.0f), (byte)(green * 255.0f), (byte)(blue * 255.0f), (byte)(alpha * 255.0f));
    }

    public ColoredLitInstance color(float red, float green, float blue) {
        return this.color((byte)(red * 255.0f), (byte)(green * 255.0f), (byte)(blue * 255.0f));
    }

    @Override
    public ColoredLitInstance light(int light) {
        this.light = light;
        return this;
    }
}

