/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model;

import com.zurrtum.create.client.flywheel.api.material.CardinalLightingMode;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.IndexSequence;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.vertex.MutableVertexList;
import com.zurrtum.create.client.flywheel.api.vertex.VertexList;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.material.StandardMaterialShaders;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.model.EmptyModel;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.SingleMeshModel;
import com.zurrtum.create.client.flywheel.lib.vertex.FullVertexView;
import com.zurrtum.create.client.flywheel.lib.vertex.VertexView;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.system.MemoryUtil;

public final class LineModelBuilder {
    private static final Material MATERIAL = SimpleMaterial.builder().shaders(StandardMaterialShaders.LINE).backfaceCulling(false).cardinalLightingMode(CardinalLightingMode.OFF).build();
    private @UnknownNullability VertexView vertexView;
    private @UnknownNullability MemoryBlock data;
    private int vertexCount = 0;

    public LineModelBuilder() {
    }

    public LineModelBuilder(int initialSegmentCount) {
        this.ensureCapacity(initialSegmentCount);
    }

    public void ensureCapacity(int segmentCount) {
        if (segmentCount < 0) {
            throw new IllegalArgumentException("Segment count must be greater than or equal to 0");
        }
        if (segmentCount == 0) {
            return;
        }
        if (this.data == null) {
            this.vertexView = new FullVertexView();
            this.data = MemoryBlock.mallocTracked((long)(segmentCount * 4) * this.vertexView.stride());
            this.vertexView.ptr(this.data.ptr());
            this.vertexCount = 0;
        } else {
            long requiredCapacity = (long)(this.vertexCount + segmentCount * 4) * this.vertexView.stride();
            if (requiredCapacity > this.data.size()) {
                this.data = this.data.realloc(requiredCapacity);
                this.vertexView.ptr(this.data.ptr());
            }
        }
    }

    public LineModelBuilder line(float x1, float y1, float z1, float x2, float y2, float z2) {
        int i;
        this.ensureCapacity(1);
        float dx = x2 - x1;
        float dy = y2 - y1;
        float dz = z2 - z1;
        float length = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        float normalX = dx / length;
        float normalY = dy / length;
        float normalZ = dz / length;
        for (i = 0; i < 2; ++i) {
            this.vertexView.x(this.vertexCount + i, x1);
            this.vertexView.y(this.vertexCount + i, y1);
            this.vertexView.z(this.vertexCount + i, z1);
            this.vertexView.x(this.vertexCount + 2 + i, x2);
            this.vertexView.y(this.vertexCount + 2 + i, y2);
            this.vertexView.z(this.vertexCount + 2 + i, z2);
        }
        for (i = 0; i < 4; ++i) {
            this.vertexView.r(this.vertexCount + i, 1.0f);
            this.vertexView.g(this.vertexCount + i, 1.0f);
            this.vertexView.b(this.vertexCount + i, 1.0f);
            this.vertexView.a(this.vertexCount + i, 1.0f);
            this.vertexView.u(this.vertexCount + i, 0.0f);
            this.vertexView.v(this.vertexCount + i, 0.0f);
            this.vertexView.overlay(this.vertexCount + i, OverlayTexture.NO_OVERLAY);
            this.vertexView.light(this.vertexCount + i, 0xF000F0);
            this.vertexView.normalX(this.vertexCount + i, normalX);
            this.vertexView.normalY(this.vertexCount + i, normalY);
            this.vertexView.normalZ(this.vertexCount + i, normalZ);
        }
        this.vertexCount += 4;
        return this;
    }

    public Model build() {
        if (this.vertexCount == 0) {
            return EmptyModel.INSTANCE;
        }
        long requiredCapacity = (long)this.vertexCount * this.vertexView.stride();
        if (this.data.size() > requiredCapacity) {
            this.data = this.data.realloc(requiredCapacity);
            this.vertexView.ptr(this.data.ptr());
        }
        this.vertexView.nativeMemoryOwner(this.data);
        this.vertexView.vertexCount(this.vertexCount);
        Vector4f boundingSphere = ModelUtil.computeBoundingSphere(this.vertexView);
        boundingSphere.w += 0.1f;
        LineMesh mesh = new LineMesh(this.vertexView, (Vector4fc)boundingSphere);
        SingleMeshModel model = new SingleMeshModel(mesh, MATERIAL);
        this.vertexView = null;
        this.data = null;
        this.vertexCount = 0;
        return model;
    }

    private static class LineMesh
    implements Mesh {
        private static final IndexSequence INDEX_SEQUENCE = (ptr, count) -> {
            int numVertices = 2 * count / 3;
            int baseVertex = 0;
            while (baseVertex < numVertices) {
                MemoryUtil.memPutInt((long)ptr, (int)baseVertex);
                MemoryUtil.memPutInt((long)(ptr + 4L), (int)(baseVertex + 1));
                MemoryUtil.memPutInt((long)(ptr + 8L), (int)(baseVertex + 2));
                MemoryUtil.memPutInt((long)(ptr + 12L), (int)(baseVertex + 3));
                MemoryUtil.memPutInt((long)(ptr + 16L), (int)(baseVertex + 2));
                MemoryUtil.memPutInt((long)(ptr + 20L), (int)(baseVertex + 1));
                baseVertex += 4;
                ptr += 24L;
            }
        };
        private final VertexList vertexList;
        private final Vector4fc boundingSphere;

        public LineMesh(VertexList vertexList, Vector4fc boundingSphere) {
            this.vertexList = vertexList;
            this.boundingSphere = boundingSphere;
        }

        @Override
        public int vertexCount() {
            return this.vertexList.vertexCount();
        }

        @Override
        public void write(MutableVertexList vertexList) {
            this.vertexList.writeAll(vertexList);
        }

        @Override
        public IndexSequence indexSequence() {
            return INDEX_SEQUENCE;
        }

        @Override
        public int indexCount() {
            return this.vertexCount() / 2 * 3;
        }

        @Override
        public Vector4fc boundingSphere() {
            return this.boundingSphere;
        }
    }
}

