/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.baked.CustomCommandRendererHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemCommandRendererHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemMeshEmitter;
import com.zurrtum.create.client.flywheel.lib.model.baked.ModelCommandRendererHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.ModelPartCommandRendererHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;

public class BakedItemModelBufferer {
    static final Map<BlendFunction, Transparency> TRANSPARENCY = Map.of(BlendFunction.ADDITIVE, Transparency.ADDITIVE, BlendFunction.LIGHTNING, Transparency.LIGHTNING, BlendFunction.GLINT, Transparency.GLINT, BlendFunction.TRANSLUCENT, Transparency.TRANSLUCENT);
    static final List<RenderType> CHUNK_LAYERS = List.of(Sheets.solidBlockSheet(), Sheets.cutoutBlockSheet(), Sheets.translucentItemSheet(), RenderTypes.glint(), RenderTypes.glintTranslucent(), RenderTypes.entityGlint());
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public static void bufferItemStack(ItemStack stack, BlockAndTintGetter level, ItemDisplayContext displayContext, ResultConsumer resultConsumer, MeshResultConsumer meshResultConsumer) {
        ClientLevel clientWorld;
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.identityPoseStack;
        ClientLevel world = level instanceof ClientLevel ? (clientWorld = (ClientLevel)level) : null;
        ItemMeshEmitterProvider provider = objects.provider;
        provider.setResultConsumer(resultConsumer, meshResultConsumer);
        ItemStackRenderState state = objects.state;
        SubmitNodeStorage queue = objects.queue;
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(state, stack, displayContext, (Level)world, null, 0);
        state.submit(poseStack, (SubmitNodeCollector)queue, 0, OverlayTexture.NO_OVERLAY, 0);
        for (SubmitNodeCollection commandQueue : queue.getSubmitsPerOrder().values()) {
            ModelCommandRendererHelper.render(poseStack, commandQueue, provider, provider, provider);
            ModelPartCommandRendererHelper.render(poseStack, commandQueue, provider, provider, provider);
            ItemCommandRendererHelper.render(poseStack, commandQueue, provider, provider);
            CustomCommandRendererHelper.render(commandQueue, provider);
        }
        queue.clear();
        provider.end();
    }

    public static Map<RenderType, Integer> getChunkLayers() {
        return BakedItemModelBufferer.THREAD_LOCAL_OBJECTS.get().chunkLayers;
    }

    private static class ThreadLocalObjects {
        public final PoseStack identityPoseStack = new PoseStack();
        public final SubmitNodeStorage queue = new SubmitNodeStorage();
        public final ItemStackRenderState state = new ItemStackRenderState();
        public final ItemMeshEmitterProvider provider = new ItemMeshEmitterProvider(this);
        public final Map<RenderType, Material> materials = new HashMap<RenderType, Material>();
        public final Map<RenderType, Integer> chunkLayers = new HashMap<RenderType, Integer>();
        public final List<ItemMeshEmitter> emitters = new ArrayList<ItemMeshEmitter>();

        private ThreadLocalObjects() {
            int size = CHUNK_LAYERS.size();
            for (int i = 0; i < size; ++i) {
                RenderType renderType = CHUNK_LAYERS.get(i);
                this.chunkLayers.put(renderType, i);
                this.emitters.add(new ItemMeshEmitter(renderType));
            }
        }
    }

    public static class ItemMeshEmitterProvider
    implements MultiBufferSource {
        private final ThreadLocalObjects objects;
        private ResultConsumer resultConsumer;
        private MeshResultConsumer meshResultConsumer;

        private ItemMeshEmitterProvider(ThreadLocalObjects objects) {
            this.objects = objects;
        }

        public void setResultConsumer(ResultConsumer resultConsumer, MeshResultConsumer meshResultConsumer) {
            this.resultConsumer = resultConsumer;
            this.meshResultConsumer = meshResultConsumer;
        }

        private void emitMesh(RenderType renderType, Mesh mesh) {
            Material material = this.objects.materials.computeIfAbsent(renderType, ItemMeshEmitterProvider::createMaterial);
            this.meshResultConsumer.accept(renderType, material, mesh);
        }

        private static Material createMaterial(RenderType renderLayer) {
            RenderSetup state = renderLayer.state;
            Map textures = state.textures;
            RenderSetup.TextureBinding texture = (RenderSetup.TextureBinding)textures.get("Sampler0");
            if (texture != null) {
                String cutout;
                Transparency transparency;
                RenderPipeline pipeline;
                Optional blendFunction;
                SimpleMaterial.Builder builder = SimpleMaterial.builder().texture(texture.location()).mipmap(false);
                if (!state.useLightmap) {
                    builder.useLight(false);
                }
                if (!state.useOverlay) {
                    builder.useOverlay(false);
                }
                if ((blendFunction = (pipeline = renderLayer.pipeline()).getBlendFunction()).isPresent() && (transparency = TRANSPARENCY.get(blendFunction.get())) != null) {
                    builder.transparency(transparency);
                }
                if ((cutout = (String)pipeline.getShaderDefines().values().get("ALPHA_CUTOUT")) != null) {
                    if (cutout.equals("0.1")) {
                        builder.cutout(CutoutShaders.ONE_TENTH);
                    } else if (cutout.equals("0.5")) {
                        builder.cutout(CutoutShaders.HALF);
                    }
                }
                return builder.build();
            }
            return Materials.TRANSLUCENT_ENTITY;
        }

        public VertexConsumer getBuffer(RenderType layer) {
            ItemMeshEmitter emitter;
            Integer index = this.objects.chunkLayers.get(layer);
            if (index == null) {
                this.objects.chunkLayers.put(layer, this.objects.chunkLayers.size());
                emitter = new ItemMeshEmitter(layer);
                emitter.prepare(this.resultConsumer, this::emitMesh);
                this.objects.emitters.add(emitter);
            } else {
                emitter = this.objects.emitters.get(index);
                if (emitter.isEnd()) {
                    emitter.prepare(this.resultConsumer, this::emitMesh);
                }
            }
            return emitter;
        }

        public void end() {
            for (ItemMeshEmitter emitter : this.objects.emitters) {
                emitter.end();
            }
        }
    }

    public static interface ResultConsumer {
        public void accept(RenderType var1, boolean var2, MeshData var3);
    }

    public static interface MeshResultConsumer {
        public void accept(RenderType var1, Material var2, Mesh var3);
    }
}

