/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBufferer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;

class ChunkLayerSortedListBuilder<T> {
    private static final ThreadLocal<ChunkLayerSortedListBuilder<?>> THREAD_LOCAL = ThreadLocal.withInitial(ChunkLayerSortedListBuilder::new);
    private final ObjectArrayList<T>[] lists = new ObjectArrayList[BakedModelBufferer.CHUNK_LAYER_AMOUNT];

    private ChunkLayerSortedListBuilder() {
        for (int layerIndex = 0; layerIndex < BakedModelBufferer.CHUNK_LAYER_AMOUNT; ++layerIndex) {
            ObjectArrayList list;
            this.lists[layerIndex] = list = new ObjectArrayList();
        }
    }

    public static <T> ChunkLayerSortedListBuilder<T> getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    public void add(ChunkSectionLayer renderType, T obj) {
        Integer layerIndex = BakedModelBufferer.CHUNK_LAYERS_INDEX.get(renderType);
        if (layerIndex == null) {
            throw new IllegalArgumentException("RenderType '" + String.valueOf(renderType) + "' is not a chunk layer");
        }
        ObjectArrayList<T> list = this.lists[layerIndex];
        list.add(obj);
    }

    public ImmutableList<T> build() {
        int size = 0;
        for (ObjectArrayList<T> list : this.lists) {
            size += list.size();
        }
        Object[] array = new Object[size];
        int destPos = 0;
        for (ObjectArrayList<T> list : this.lists) {
            System.arraycopy(list.elements(), 0, array, destPos, list.size());
            destPos += list.size();
            list.clear();
        }
        return ImmutableList.copyOf((Object[])array);
    }
}

