/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.CustomFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;

public class CustomCommandRendererHelper {
    public static void render(SubmitNodeCollection queue, MultiBufferSource vertexConsumers) {
        CustomFeatureRenderer.Storage commands = queue.getCustomGeometrySubmits();
        for (Map.Entry entry : commands.customGeometrySubmits.entrySet()) {
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer((RenderType)entry.getKey());
            for (SubmitNodeStorage.CustomGeometrySubmit customCommand : (List)entry.getValue()) {
                customCommand.customGeometryRenderer().render(customCommand.pose(), vertexConsumer);
            }
        }
    }

    public static VertexConsumer getOutlineBuffer(MultiBufferSource vertexConsumers, RenderType layer, int color) {
        if (layer.isOutline()) {
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(layer);
            return new OutlineBufferSource.EntityOutlineGenerator(vertexConsumer, color);
        }
        Optional optional = layer.outline();
        if (optional.isPresent()) {
            VertexConsumer vertexConsumer2 = vertexConsumers.getBuffer((RenderType)optional.get());
            return new OutlineBufferSource.EntityOutlineGenerator(vertexConsumer2, color);
        }
        return null;
    }
}

