/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBufferer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import org.jetbrains.annotations.UnknownNullability;

class MeshEmitter
implements VertexConsumer {
    private final ChunkSectionLayer renderType;
    private final ByteBufferBuilder byteBufferBuilder;
    private @UnknownNullability BufferBuilder bufferBuilder;
    private BakedModelBufferer.ResultConsumer resultConsumer;
    private boolean currentShade;

    MeshEmitter(ChunkSectionLayer renderType) {
        this.renderType = renderType;
        this.byteBufferBuilder = new ByteBufferBuilder(renderType.bufferSize());
    }

    public void prepare(BakedModelBufferer.ResultConsumer resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public void end() {
        if (this.bufferBuilder != null) {
            this.emit();
        }
        this.resultConsumer = null;
    }

    public BufferBuilder unwrap(boolean shade) {
        this.prepareForGeometry(shade);
        return this.bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (this.bufferBuilder == null) {
            this.bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        } else if (shade != this.currentShade) {
            this.emit();
            this.bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        }
        this.currentShade = shade;
    }

    private void prepareForGeometry(BakedQuad quad) {
        this.prepareForGeometry(quad.shade());
    }

    private void emit() {
        MeshData data = this.bufferBuilder.build();
        this.bufferBuilder = null;
        if (data != null) {
            this.resultConsumer.accept(this.renderType, this.currentShade, data);
            data.close();
        }
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.putBulkData(pose, quad, red, green, blue, alpha, packedLight, packedOverlay);
    }

    public void putBulkData(PoseStack.Pose pose, BakedQuad quad, float[] brightnesses, float red, float green, float blue, float alpha, int[] lights, int overlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.putBulkData(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay);
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setColor(int color) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setUv(float u, float v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setUv1(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setUv2(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setNormal(float normalX, float normalY, float normalZ) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    public VertexConsumer setLineWidth(float width) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }
}

