/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.MeshData;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.vertex.NoOverlayVertexView;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public final class MeshHelper {
    private MeshHelper() {
    }

    public static SimpleQuadMesh blockVerticesToMesh(MeshData data, @Nullable String meshDescriptor) {
        MeshData.DrawState drawState = data.drawState();
        int vertexCount = drawState.vertexCount();
        long srcStride = drawState.format().getVertexSize();
        NoOverlayVertexView vertexView = new NoOverlayVertexView();
        long dstStride = vertexView.stride();
        ByteBuffer src = data.vertexBuffer();
        MemoryBlock dst = MemoryBlock.mallocTracked((long)vertexCount * dstStride);
        long srcPtr = MemoryUtil.memAddress((ByteBuffer)src);
        long dstPtr = dst.ptr();
        long bytesToCopy = Math.min(dstStride, 31L);
        for (int i = 0; i < vertexCount; ++i) {
            MemoryUtil.memCopy((long)(srcPtr + srcStride * (long)i), (long)(dstPtr + dstStride * (long)i), (long)bytesToCopy);
        }
        vertexView.ptr(dstPtr);
        vertexView.vertexCount(vertexCount);
        vertexView.nativeMemoryOwner(dst);
        return new SimpleQuadMesh(vertexView, meshDescriptor);
    }
}

