/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.flywheel.lib.model.baked.CustomCommandRendererHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.SharedConstants;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.resources.model.ModelBakery;

public class ModelCommandRendererHelper {
    public static void render(PoseStack matrices, SubmitNodeCollection queue, MultiBufferSource vertexConsumers, MultiBufferSource outlineVertexConsumers, MultiBufferSource crumblingOverlayVertexConsumers) {
        ModelFeatureRenderer.Storage commands = queue.getModelSubmits();
        ModelCommandRendererHelper.renderAll(matrices, vertexConsumers, outlineVertexConsumers, commands.opaqueModelSubmits, crumblingOverlayVertexConsumers);
        commands.translucentModelSubmits.sort(Comparator.comparingDouble(modelCommand -> -modelCommand.position().lengthSquared()));
        ModelCommandRendererHelper.renderAllBlended(matrices, vertexConsumers, outlineVertexConsumers, commands.translucentModelSubmits, crumblingOverlayVertexConsumers);
    }

    private static void renderAllBlended(PoseStack matrices, MultiBufferSource vertexConsumers, MultiBufferSource outlineVertexConsumers, List<SubmitNodeStorage.TranslucentModelSubmit<?>> blendedModelCommands, MultiBufferSource crumblingOverlayVertexConsumers) {
        for (SubmitNodeStorage.TranslucentModelSubmit<?> blendedModelCommand : blendedModelCommands) {
            ModelCommandRendererHelper.render(matrices, blendedModelCommand.modelSubmit(), blendedModelCommand.renderType(), vertexConsumers.getBuffer(blendedModelCommand.renderType()), outlineVertexConsumers, crumblingOverlayVertexConsumers);
        }
    }

    private static void renderAll(PoseStack matrices, MultiBufferSource vertexConsumers, MultiBufferSource outlineVertexConsumers, Map<RenderType, List<SubmitNodeStorage.ModelSubmit<?>>> modelCommands, MultiBufferSource crumblingOverlayVertexConsumers) {
        Collection<Map.Entry<RenderType, List<SubmitNodeStorage.ModelSubmit<?>>>> iterable;
        if (SharedConstants.DEBUG_SHUFFLE_MODELS) {
            ArrayList list = new ArrayList(modelCommands.entrySet());
            Collections.shuffle(list);
            iterable = list;
        } else {
            iterable = modelCommands.entrySet();
        }
        for (Map.Entry entry : iterable) {
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer((RenderType)entry.getKey());
            for (SubmitNodeStorage.ModelSubmit modelCommand : (List)entry.getValue()) {
                ModelCommandRendererHelper.render(matrices, modelCommand, (RenderType)entry.getKey(), vertexConsumer, outlineVertexConsumers, crumblingOverlayVertexConsumers);
            }
        }
    }

    private static <S> void render(PoseStack matrices, SubmitNodeStorage.ModelSubmit<S> model, RenderType renderLayer, VertexConsumer vertexConsumer, MultiBufferSource outlineVertexConsumers, MultiBufferSource crumblingOverlayVertexConsumers) {
        VertexConsumer vertexConsumer3;
        matrices.pushPose();
        matrices.last().set(model.pose());
        Model model2 = model.model();
        VertexConsumer vertexConsumer2 = model.sprite() == null ? vertexConsumer : model.sprite().wrap(vertexConsumer);
        model2.setupAnim(model.state());
        model2.renderToBuffer(matrices, vertexConsumer2, model.lightCoords(), model.overlayCoords(), model.tintedColor());
        if (model.outlineColor() != 0 && (renderLayer.outline().isPresent() || renderLayer.isOutline()) && (vertexConsumer3 = CustomCommandRendererHelper.getOutlineBuffer(outlineVertexConsumers, renderLayer, model.outlineColor())) != null) {
            if (model.sprite() != null) {
                vertexConsumer3 = model.sprite().wrap(vertexConsumer3);
            }
            model2.renderToBuffer(matrices, vertexConsumer3, model.lightCoords(), model.overlayCoords(), model.tintedColor());
        }
        if (model.crumblingOverlay() != null && renderLayer.affectsCrumbling()) {
            vertexConsumer3 = new SheetedDecalTextureGenerator(crumblingOverlayVertexConsumers.getBuffer((RenderType)ModelBakery.DESTROY_TYPES.get(model.crumblingOverlay().progress())), model.crumblingOverlay().cameraPose(), 1.0f);
            model2.renderToBuffer(matrices, model.sprite() == null ? vertexConsumer3 : model.sprite().wrap(vertexConsumer3), model.lightCoords(), model.overlayCoords(), model.tintedColor());
        }
        matrices.popPose();
    }
}

