/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.UnknownNullability;

public final class PartialModel {
    static final ConcurrentMap<Identifier, PartialModel> ALL = new MapMaker().weakValues().makeMap();
    static boolean populateOnInit = false;
    private final Identifier modelLocation;
    @UnknownNullability SimpleModelWrapper bakedModel;

    private PartialModel(Identifier modelLocation) {
        this.modelLocation = modelLocation;
        if (populateOnInit) {
            throw new RuntimeException("Loading new models after resolve models is not supported");
        }
    }

    public static PartialModel of(Identifier modelLocation) {
        return ALL.computeIfAbsent(modelLocation, PartialModel::new);
    }

    public @UnknownNullability SimpleModelWrapper get() {
        return this.bakedModel;
    }

    public Identifier modelLocation() {
        return this.modelLocation;
    }
}

