/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.part;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.client.flywheel.lib.math.DataPacker;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import org.lwjgl.system.MemoryUtil;

public class VertexWriter
implements VertexConsumer {
    private static final int STRIDE = 23;
    private MemoryBlock data = MemoryBlock.malloc(2944L);
    private int vertexCount;
    private boolean filledTexture = true;
    private boolean filledNormal = true;

    public VertexConsumer addVertex(float x, float y, float z) {
        this.endLastVertex();
        ++this.vertexCount;
        long byteSize = this.vertexCount * 23;
        long capacity = this.data.size();
        if (byteSize > capacity) {
            this.data = this.data.realloc(capacity * 2L);
        }
        this.filledTexture = false;
        this.filledNormal = false;
        long ptr = this.vertexPtr();
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        return this;
    }

    public VertexConsumer setColor(int color) {
        return this;
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        if (!this.filledTexture) {
            long ptr = this.vertexPtr();
            MemoryUtil.memPutFloat((long)(ptr + 12L), (float)u);
            MemoryUtil.memPutFloat((long)(ptr + 16L), (float)v);
            this.filledTexture = true;
        }
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        if (!this.filledNormal) {
            long ptr = this.vertexPtr();
            MemoryUtil.memPutByte((long)(ptr + 20L), (byte)DataPacker.packNormI8(x));
            MemoryUtil.memPutByte((long)(ptr + 21L), (byte)DataPacker.packNormI8(y));
            MemoryUtil.memPutByte((long)(ptr + 22L), (byte)DataPacker.packNormI8(z));
            this.filledNormal = true;
        }
        return this;
    }

    public VertexConsumer setLineWidth(float width) {
        return this;
    }

    private long vertexPtr() {
        return this.data.ptr() + (long)((this.vertexCount - 1) * 23);
    }

    private void endLastVertex() {
        if (!(this.vertexCount == 0 || this.filledTexture && this.filledNormal)) {
            throw new IllegalStateException("Missing elements in vertex");
        }
    }

    public MemoryBlock copyDataAndReset() {
        this.endLastVertex();
        MemoryBlock dataCopy = MemoryBlock.mallocTracked(this.vertexCount * 23);
        this.data.copyTo(dataCopy);
        this.vertexCount = 0;
        this.filledTexture = true;
        this.filledNormal = true;
        return dataCopy;
    }
}

