/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.transform;

import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public interface Rotate<Self extends Rotate<Self>> {
    public Self rotate(Quaternionfc var1);

    default public Self rotate(AxisAngle4f axisAngle) {
        return this.rotate((Quaternionfc)new Quaternionf(axisAngle));
    }

    default public Self rotate(float radians, float axisX, float axisY, float axisZ) {
        if (radians == 0.0f) {
            return this.self();
        }
        return this.rotate((Quaternionfc)new Quaternionf().setAngleAxis(radians, axisX, axisY, axisZ));
    }

    default public Self rotate(float radians, Axis axis) {
        if (radians == 0.0f) {
            return this.self();
        }
        return this.rotate((Quaternionfc)axis.rotation(radians));
    }

    default public Self rotate(float radians, Vector3fc axis) {
        return this.rotate(radians, axis.x(), axis.y(), axis.z());
    }

    default public Self rotate(float radians, Direction axis) {
        return this.rotate(radians, axis.getStepX(), axis.getStepY(), axis.getStepZ());
    }

    default public Self rotate(float radians, Direction.Axis axis) {
        return this.rotate(radians, Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
    }

    default public Self rotateDegrees(float degrees, float axisX, float axisY, float axisZ) {
        return this.rotate((float)Math.PI / 180 * degrees, axisX, axisY, axisZ);
    }

    default public Self rotateDegrees(float degrees, Axis axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, Vector3fc axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, Direction axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateDegrees(float degrees, Direction.Axis axis) {
        return this.rotate((float)Math.PI / 180 * degrees, axis);
    }

    default public Self rotateX(float radians) {
        return this.rotate(radians, Axis.XP);
    }

    default public Self rotateY(float radians) {
        return this.rotate(radians, Axis.YP);
    }

    default public Self rotateZ(float radians) {
        return this.rotate(radians, Axis.ZP);
    }

    default public Self rotateXDegrees(float degrees) {
        return this.rotateX((float)Math.PI / 180 * degrees);
    }

    default public Self rotateYDegrees(float degrees) {
        return this.rotateY((float)Math.PI / 180 * degrees);
    }

    default public Self rotateZDegrees(float degrees) {
        return this.rotateZ((float)Math.PI / 180 * degrees);
    }

    default public Self rotateToFace(Direction facing) {
        return (Self)(switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> (Rotate)this.rotateXDegrees(-90.0f);
            case Direction.UP -> (Rotate)this.rotateXDegrees(90.0f);
            case Direction.NORTH -> (Rotate)this.self();
            case Direction.SOUTH -> (Rotate)this.rotateYDegrees(180.0f);
            case Direction.WEST -> (Rotate)this.rotateYDegrees(90.0f);
            case Direction.EAST -> (Rotate)this.rotateYDegrees(270.0f);
        });
    }

    default public Self rotateTo(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        return this.rotate((Quaternionfc)new Quaternionf().rotationTo(fromX, fromY, fromZ, toX, toY, toZ));
    }

    default public Self rotateTo(Vector3fc from, Vector3fc to) {
        return this.rotateTo(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
    }

    default public Self rotateTo(Direction from, Direction to) {
        return this.rotateTo(from.getStepX(), from.getStepY(), from.getStepZ(), to.getStepX(), to.getStepY(), to.getStepZ());
    }

    default public Self self() {
        return (Self)this;
    }
}

