/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.level.LevelAccessor;

public final class LevelAttached<T> {
    private static final ConcurrentLinkedDeque<WeakReference<LevelAttached<?>>> ALL = new ConcurrentLinkedDeque();
    private static final Cleaner CLEANER = Cleaner.create();
    private final LoadingCache<LevelAccessor, T> cache;

    public LevelAttached(final Function<LevelAccessor, T> factory, Consumer<T> finalizer) {
        WeakReference thisRef = new WeakReference(this);
        ALL.add(thisRef);
        this.cache = CacheBuilder.newBuilder().removalListener(n -> finalizer.accept(n.getValue())).build(new CacheLoader<LevelAccessor, T>(this){

            public T load(LevelAccessor key) {
                return factory.apply(key);
            }
        });
        CLEANER.register(this, new CleaningAction(thisRef, this.cache));
    }

    public LevelAttached(Function<LevelAccessor, T> factory) {
        this(factory, t -> {});
    }

    public static void invalidateLevel(LevelAccessor level) {
        Iterator<WeakReference<LevelAttached<?>>> iterator = ALL.iterator();
        while (iterator.hasNext()) {
            LevelAttached attached = (LevelAttached)iterator.next().get();
            if (attached == null) {
                iterator.remove();
                continue;
            }
            attached.remove(level);
        }
    }

    public T get(LevelAccessor level) {
        return (T)this.cache.getUnchecked((Object)level);
    }

    public void remove(LevelAccessor level) {
        this.cache.invalidate((Object)level);
    }

    public T refresh(LevelAccessor level) {
        this.remove(level);
        return this.get(level);
    }

    public void reset() {
        this.cache.invalidateAll();
    }

    private static class CleaningAction
    implements Runnable {
        private final WeakReference<LevelAttached<?>> ref;
        private final LoadingCache<LevelAccessor, ?> cache;

        private CleaningAction(WeakReference<LevelAttached<?>> ref, LoadingCache<LevelAccessor, ?> cache) {
            this.ref = ref;
            this.cache = cache;
        }

        @Override
        public void run() {
            ALL.remove(this.ref);
            this.cache.invalidateAll();
        }
    }
}

