/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual;

import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.LightUpdatedVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.math.MoreMath;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.FrustumIntersection;

public abstract class AbstractBlockEntityVisual<T extends BlockEntity>
extends AbstractVisual
implements BlockEntityVisual<T>,
LightUpdatedVisual {
    protected final T blockEntity;
    protected final BlockPos pos;
    protected final BlockPos visualPos;
    protected final BlockState blockState;
    protected @UnknownNullability SectionTrackedVisual.SectionCollector lightSections;

    public AbstractBlockEntityVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity.getLevel(), partialTick);
        this.blockEntity = blockEntity;
        this.pos = blockEntity.getBlockPos();
        this.blockState = blockEntity.getBlockState();
        this.visualPos = this.pos.subtract(ctx.renderOrigin());
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        this.lightSections = sectionCollector;
        this.lightSections.sections(LongSet.of((long)SectionPos.asLong((BlockPos)this.pos)));
    }

    public BlockPos getVisualPosition() {
        return this.visualPos;
    }

    public boolean isVisible(FrustumIntersection frustum) {
        float x = (float)this.visualPos.getX() + 0.5f;
        float y = (float)this.visualPos.getY() + 0.5f;
        float z = (float)this.visualPos.getZ() + 0.5f;
        return frustum.testSphere(x, y, z, MoreMath.SQRT_3_OVER_2);
    }

    public boolean doDistanceLimitThisFrame(DynamicVisual.Context context) {
        return !context.limiter().shouldUpdate(this.pos.distToCenterSqr((Position)context.camera().position()));
    }

    protected int computePackedLight() {
        return LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.pos);
    }

    protected void relight(BlockPos pos, FlatLit ... instances) {
        FlatLit.relight(LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)pos), instances);
    }

    protected void relight(FlatLit ... instances) {
        this.relight(this.pos, instances);
    }

    protected void relight(BlockPos pos, Iterator<@Nullable FlatLit> instances) {
        FlatLit.relight(LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)pos), instances);
    }

    protected void relight(Iterator<@Nullable FlatLit> instances) {
        this.relight(this.pos, instances);
    }

    protected void relight(BlockPos pos, Iterable<@Nullable FlatLit> instances) {
        FlatLit.relight(LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)pos), instances);
    }

    protected void relight(Iterable<@Nullable FlatLit> instances) {
        this.relight(this.pos, instances);
    }
}

