/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual.component;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.LineModelBuilder;
import com.zurrtum.create.client.flywheel.lib.visual.component.EntityComponent;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class HitboxComponent
implements EntityComponent {
    public static final Model BOX_MODEL = new LineModelBuilder(12).line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f).line(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f).line(1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f).line(1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f).build();
    public static final Model LINE_MODEL = new LineModelBuilder(1).line(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f).build();
    private final VisualizationContext context;
    private final Entity entity;
    private final SmartRecycler<Model, TransformedInstance> recycler;
    private boolean showEyeBox;

    public HitboxComponent(VisualizationContext context, Entity entity) {
        this.context = context;
        this.entity = entity;
        this.showEyeBox = entity instanceof LivingEntity;
        this.recycler = new SmartRecycler<Model, TransformedInstance>(this::createInstance);
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = this.context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(0xF000F0);
        instance.setChanged();
        return instance;
    }

    public boolean doesShowEyeBox() {
        return this.showEyeBox;
    }

    public HitboxComponent showEyeBox(boolean showEyeBox) {
        this.showEyeBox = showEyeBox;
        return this;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.recycler.resetCount();
        boolean shouldRenderHitBoxes = Minecraft.getInstance().debugEntries.isCurrentlyEnabled(DebugScreenEntries.ENTITY_HITBOXES);
        if (shouldRenderHitBoxes && !this.entity.isInvisible() && !Minecraft.getInstance().showOnlyReducedInfo()) {
            float partialTick = context.partialTick();
            double entityX = Mth.lerp((double)partialTick, (double)this.entity.xOld, (double)this.entity.getX());
            double entityY = Mth.lerp((double)partialTick, (double)this.entity.yOld, (double)this.entity.getY());
            double entityZ = Mth.lerp((double)partialTick, (double)this.entity.zOld, (double)this.entity.getZ());
            AABB bb = this.entity.getBoundingBox();
            double boxX = entityX + bb.minX - this.entity.getX();
            double boxY = entityY + bb.minY - this.entity.getY();
            double boxZ = entityZ + bb.minZ - this.entity.getZ();
            float widthX = (float)(bb.maxX - bb.minX);
            float widthY = (float)(bb.maxY - bb.minY);
            float widthZ = (float)(bb.maxZ - bb.minZ);
            ((TransformedInstance)this.recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, boxY, boxZ)).scale(widthX, widthY, widthZ).setChanged();
            if (this.showEyeBox) {
                ((TransformedInstance)this.recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, entityY + (double)this.entity.getEyeHeight() - 0.01, boxZ)).scale(widthX, 0.02f, widthZ).color(255, 0, 0).setChanged();
            }
            Vec3 viewVector = this.entity.getViewVector(partialTick);
            ((TransformedInstance)this.recycler.get(LINE_MODEL).setIdentityTransform().translate(entityX, entityY + (double)this.entity.getEyeHeight(), entityZ)).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, 1.0f, 0.0f, (float)viewVector.x, (float)viewVector.y, (float)viewVector.z)).color(0, 0, 255).setChanged();
        }
        this.recycler.discardExtra();
    }

    @Override
    public void delete() {
        this.recycler.delete();
    }
}

