/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual.component;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.material.WriteMask;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.vertex.MutableVertexList;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.ShadowInstance;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.QuadMesh;
import com.zurrtum.create.client.flywheel.lib.model.SingleMeshModel;
import com.zurrtum.create.client.flywheel.lib.visual.component.EntityComponent;
import com.zurrtum.create.client.flywheel.lib.visual.util.InstanceRecycler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class ShadowComponent
implements EntityComponent {
    private static final Identifier SHADOW_TEXTURE = Identifier.withDefaultNamespace((String)"textures/misc/shadow.png");
    private static final Material SHADOW_MATERIAL = SimpleMaterial.builder().texture(SHADOW_TEXTURE).mipmap(false).polygonOffset(true).transparency(Transparency.TRANSLUCENT).writeMask(WriteMask.COLOR).build();
    private static final Model SHADOW_MODEL = new SingleMeshModel(ShadowMesh.INSTANCE, SHADOW_MATERIAL);
    private final VisualizationContext context;
    private final Entity entity;
    private final Level level;
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private final InstanceRecycler<ShadowInstance> instances = new InstanceRecycler<ShadowInstance>(this::createInstance);
    private float radius = 0.0f;
    private float strength = 1.0f;

    public ShadowComponent(VisualizationContext context, Entity entity) {
        this.context = context;
        this.entity = entity;
        this.level = entity.level();
    }

    private ShadowInstance createInstance() {
        return this.context.instancerProvider().instancer(InstanceTypes.SHADOW, SHADOW_MODEL).createInstance();
    }

    public float radius() {
        return this.radius;
    }

    public float strength() {
        return this.strength;
    }

    public ShadowComponent radius(float radius) {
        this.radius = Math.min(radius, 32.0f);
        return this;
    }

    public ShadowComponent strength(float strength) {
        this.strength = strength;
        return this;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        this.instances.resetCount();
        boolean shadowsEnabled = (Boolean)Minecraft.getInstance().options.entityShadows().get();
        if (shadowsEnabled && this.radius > 0.0f && !this.entity.isInvisible()) {
            this.setupInstances(context);
        }
        this.instances.discardExtra();
    }

    private void setupInstances(DynamicVisual.Context context) {
        double entityX = Mth.lerp((double)context.partialTick(), (double)this.entity.xOld, (double)this.entity.getX());
        double entityY = Mth.lerp((double)context.partialTick(), (double)this.entity.yOld, (double)this.entity.getY());
        double entityZ = Mth.lerp((double)context.partialTick(), (double)this.entity.zOld, (double)this.entity.getZ());
        float castDistance = Math.min(this.strength * 2.0f, this.radius);
        int minXPos = Mth.floor((double)(entityX - (double)this.radius));
        int maxXPos = Mth.floor((double)(entityX + (double)this.radius));
        int minYPos = Mth.floor((double)(entityY - (double)castDistance));
        int maxYPos = Mth.floor((double)entityY);
        int minZPos = Mth.floor((double)(entityZ - (double)this.radius));
        int maxZPos = Mth.floor((double)(entityZ + (double)this.radius));
        for (int z = minZPos; z <= maxZPos; ++z) {
            for (int x = minXPos; x <= maxXPos; ++x) {
                this.pos.set(x, 0, z);
                ChunkAccess chunk = this.level.getChunk((BlockPos)this.pos);
                for (int y = minYPos; y <= maxYPos; ++y) {
                    this.pos.setY(y);
                    float strengthGivenYFalloff = this.strength - (float)(entityY - (double)this.pos.getY()) * 0.5f;
                    this.setupInstance(chunk, this.pos, (float)entityX, (float)entityZ, strengthGivenYFalloff);
                }
            }
        }
    }

    private void setupInstance(ChunkAccess chunk, BlockPos.MutableBlockPos pos, float entityX, float entityZ, float strength) {
        int maxLocalRawBrightness = this.level.getMaxLocalRawBrightness((BlockPos)pos);
        if (maxLocalRawBrightness <= 3) {
            return;
        }
        float blockBrightness = LightTexture.getBrightness((DimensionType)this.level.dimensionType(), (int)maxLocalRawBrightness);
        float alpha = strength * 0.5f * blockBrightness;
        if (alpha < 0.0f) {
            return;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        pos.setY(pos.getY() - 1);
        VoxelShape shape = this.getShapeAt(chunk, (BlockPos)pos);
        if (shape == null) {
            return;
        }
        Vec3i renderOrigin = this.context.renderOrigin();
        int x = pos.getX() - renderOrigin.getX();
        int y = pos.getY() - renderOrigin.getY() + 1;
        int z = pos.getZ() - renderOrigin.getZ();
        double minX = (double)x + shape.min(Direction.Axis.X);
        double minY = (double)y + shape.min(Direction.Axis.Y);
        double minZ = (double)z + shape.min(Direction.Axis.Z);
        double maxX = (double)x + shape.max(Direction.Axis.X);
        double maxZ = (double)z + shape.max(Direction.Axis.Z);
        ShadowInstance instance = this.instances.get();
        instance.x = (float)minX;
        instance.y = (float)minY;
        instance.z = (float)minZ;
        instance.entityX = entityX - (float)renderOrigin.getX();
        instance.entityZ = entityZ - (float)renderOrigin.getZ();
        instance.sizeX = (float)(maxX - minX);
        instance.sizeZ = (float)(maxZ - minZ);
        instance.alpha = alpha;
        instance.radius = this.radius;
        instance.setChanged();
    }

    @Nullable
    private VoxelShape getShapeAt(ChunkAccess chunk, BlockPos pos) {
        BlockState state = chunk.getBlockState(pos);
        if (state.getRenderShape() == RenderShape.INVISIBLE) {
            return null;
        }
        if (!state.isCollisionShapeFullBlock((BlockGetter)chunk, pos)) {
            return null;
        }
        VoxelShape shape = state.getShape((BlockGetter)chunk, pos);
        if (shape.isEmpty()) {
            return null;
        }
        return shape;
    }

    @Override
    public void delete() {
        this.instances.delete();
    }

    private static class ShadowMesh
    implements QuadMesh {
        private static final Vector4fc BOUNDING_SPHERE = new Vector4f(0.5f, 0.0f, 0.5f, (float)(Math.sqrt(2.0) * 0.5));
        private static final ShadowMesh INSTANCE = new ShadowMesh();

        private ShadowMesh() {
        }

        @Override
        public int vertexCount() {
            return 4;
        }

        @Override
        public void write(MutableVertexList vertexList) {
            ShadowMesh.writeVertex(vertexList, 0, 0.0f, 0.0f);
            ShadowMesh.writeVertex(vertexList, 1, 0.0f, 1.0f);
            ShadowMesh.writeVertex(vertexList, 2, 1.0f, 1.0f);
            ShadowMesh.writeVertex(vertexList, 3, 1.0f, 0.0f);
        }

        private static void writeVertex(MutableVertexList vertexList, int i, float x, float z) {
            vertexList.x(i, x);
            vertexList.y(i, 0.0f);
            vertexList.z(i, z);
            vertexList.r(i, 1.0f);
            vertexList.g(i, 1.0f);
            vertexList.b(i, 1.0f);
            vertexList.u(i, 0.0f);
            vertexList.v(i, 0.0f);
            vertexList.light(i, 0xF000F0);
            vertexList.overlay(i, OverlayTexture.NO_OVERLAY);
            vertexList.normalX(i, 0.0f);
            vertexList.normalY(i, 1.0f);
            vertexList.normalZ(i, 0.0f);
        }

        @Override
        public Vector4fc boundingSphere() {
            return BOUNDING_SPHERE;
        }
    }
}

