/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visualization;

import com.zurrtum.create.client.flywheel.api.visual.EntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.EntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public final class SimpleEntityVisualizer<T extends Entity>
implements EntityVisualizer<T> {
    private final Factory<T> visualFactory;
    private final Predicate<T> skipVanillaRender;

    public SimpleEntityVisualizer(Factory<T> visualFactory, Predicate<T> skipVanillaRender) {
        this.visualFactory = visualFactory;
        this.skipVanillaRender = skipVanillaRender;
    }

    @Override
    public EntityVisual<? super T> createVisual(VisualizationContext ctx, T entity, float partialTick) {
        return this.visualFactory.create(ctx, entity, partialTick);
    }

    @Override
    public boolean skipVanillaRender(T entity) {
        return this.skipVanillaRender.test(entity);
    }

    public static <T extends Entity> Builder<T> builder(EntityType<T> type) {
        return new Builder<T>(type);
    }

    @FunctionalInterface
    public static interface Factory<T extends Entity> {
        public EntityVisual<? super T> create(VisualizationContext var1, T var2, float var3);
    }

    public static final class Builder<T extends Entity> {
        private final EntityType<T> type;
        @Nullable
        private Factory<T> visualFactory;
        @Nullable
        private Predicate<T> skipVanillaRender;

        public Builder(EntityType<T> type) {
            this.type = type;
        }

        public Builder<T> factory(Factory<T> visualFactory) {
            this.visualFactory = visualFactory;
            return this;
        }

        public Builder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
            this.skipVanillaRender = skipVanillaRender;
            return this;
        }

        public Builder<T> neverSkipVanillaRender() {
            this.skipVanillaRender = entity -> false;
            return this;
        }

        public SimpleEntityVisualizer<T> apply() {
            Objects.requireNonNull(this.visualFactory, "Visual factory cannot be null!");
            if (this.skipVanillaRender == null) {
                this.skipVanillaRender = entity -> true;
            }
            SimpleEntityVisualizer<T> visualizer = new SimpleEntityVisualizer<T>(this.visualFactory, this.skipVanillaRender);
            VisualizerRegistry.setVisualizer(this.type, visualizer);
            return visualizer;
        }
    }
}

