/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ValueBoxRenderer {
    public static void renderItemIntoValueBox(ItemStackRenderState state, SubmitNodeCollector queue, PoseStack ms, int light, float offset) {
        boolean blockItem = state.usesBlockLight();
        float scale = (!blockItem ? 0.5f : 1.0f) + 0.015625f;
        float zOffset = (!blockItem ? -0.15f : 0.0f) + offset;
        ms.scale(scale, scale, scale);
        ms.translate(0.0f, 0.0f, zOffset);
        state.submit(ms, queue, light, OverlayTexture.NO_OVERLAY, 0);
    }

    public static void renderFlatItemIntoValueBox(ItemStackRenderState state, SubmitNodeCollector queue, PoseStack ms, int light) {
        int bl = light >> 4 & 0xF;
        int sl = light >> 20 & 0xF;
        int itemLight = Mth.floor((double)((double)sl + 0.5)) << 20 | (Mth.floor((double)((double)bl + 0.5)) & 0xF) << 4;
        ms.pushPose();
        TransformStack.of(ms).rotateXDegrees(230.0f);
        Matrix3f copy = new Matrix3f((Matrix3fc)ms.last().normal());
        ms.popPose();
        ms.pushPose();
        ((PoseTransformStack)TransformStack.of(ms).translate(0.0f, 0.0f, -0.25f).translate(0.0, 0.0, 0.03225)).rotateYDegrees(180.0f);
        PoseStack squashedMS = new PoseStack();
        squashedMS.last().pose().mul((Matrix4fc)ms.last().pose());
        squashedMS.scale(0.5f, 0.5f, 9.765625E-4f);
        squashedMS.last().normal().set((Matrix3fc)copy);
        state.submit(squashedMS, queue, itemLight, OverlayTexture.NO_OVERLAY, 0);
        ms.popPose();
    }

    public static float customZOffset(Item item) {
        float nudge = -0.1f;
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            if (block instanceof AbstractSimpleShaftBlock) {
                return nudge;
            }
            if (block instanceof FenceBlock) {
                return nudge;
            }
            if (block.builtInRegistryHolder().is(BlockTags.BUTTONS)) {
                return nudge;
            }
            if (block == Blocks.END_ROD) {
                return nudge;
            }
        }
        return 0.0f;
    }
}

