/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.audio;

import com.zurrtum.create.client.foundation.blockEntity.behaviour.audio.AudioBehaviour;
import com.zurrtum.create.client.foundation.sound.SoundScapes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.ICogWheel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;

public class KineticAudioBehaviour<T extends KineticBlockEntity>
extends AudioBehaviour<T> {
    public KineticAudioBehaviour(T be) {
        super(be);
    }

    @Override
    public void tickAudio() {
        Block block;
        float componentSpeed = Math.abs(((KineticBlockEntity)this.blockEntity).getSpeed());
        if (componentSpeed == 0.0f) {
            return;
        }
        float pitch = Mth.clamp((float)(componentSpeed / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        if (((KineticBlockEntity)this.blockEntity).isNoisy()) {
            SoundScapes.play(SoundScapes.AmbienceGroup.KINETIC, ((KineticBlockEntity)this.blockEntity).getBlockPos(), pitch);
        }
        if (ICogWheel.isSmallCog(block = ((KineticBlockEntity)this.blockEntity).getBlockState().getBlock()) || ICogWheel.isLargeCog(block) || block instanceof GearboxBlock) {
            SoundScapes.play(SoundScapes.AmbienceGroup.COG, ((KineticBlockEntity)this.blockEntity).getBlockPos(), pitch);
        }
    }
}

