/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.audio;

import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.decoration.steamWhistle.WhistleSoundInstance;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.audio.AudioBehaviour;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WhistleAudioBehaviour
extends AudioBehaviour<WhistleBlockEntity> {
    protected WhistleSoundInstance soundInstance;

    public WhistleAudioBehaviour(WhistleBlockEntity be) {
        super(be);
    }

    @Override
    public void tickAudio() {
        boolean powered;
        FluidTankBlockEntity tank = ((WhistleBlockEntity)this.blockEntity).getTank();
        boolean bl = powered = ((WhistleBlockEntity)this.blockEntity).isPowered() && (tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || ((WhistleBlockEntity)this.blockEntity).isVirtual());
        if (!powered) {
            if (this.soundInstance != null) {
                this.soundInstance.fadeOut();
                this.soundInstance = null;
            }
            return;
        }
        Level world = ((WhistleBlockEntity)this.blockEntity).getLevel();
        BlockPos pos = ((WhistleBlockEntity)this.blockEntity).getBlockPos();
        float f = (float)Math.pow(2.0, (double)(-((WhistleBlockEntity)this.blockEntity).pitch) / 12.0);
        boolean particle = world.getGameTime() % 8L == 0L;
        Minecraft mc = Minecraft.getInstance();
        Vec3 eyePosition = mc.getCameraEntity().getEyePosition();
        float maxVolume = (float)Mth.clamp((double)((64.0 - eyePosition.distanceTo(Vec3.atCenterOf((Vec3i)pos))) / 64.0), (double)0.0, (double)1.0);
        WhistleBlock.WhistleSize size = ((WhistleBlockEntity)this.blockEntity).getOctave();
        if (this.soundInstance == null || this.soundInstance.isStopped() || this.soundInstance.getOctave() != size) {
            this.soundInstance = new WhistleSoundInstance(size, pos);
            mc.getSoundManager().play((SoundInstance)this.soundInstance);
            AllSoundEvents.WHISTLE_CHIFF.playAt(world, (Vec3i)pos, maxVolume * 0.175f, size == WhistleBlock.WhistleSize.SMALL ? f + 0.75f : f, false);
            particle = true;
        }
        this.soundInstance.keepAlive();
        this.soundInstance.setPitch(f);
        if (!particle) {
            return;
        }
        Direction facing = ((WhistleBlockEntity)this.blockEntity).getBlockState().getOptionalValue(WhistleBlock.FACING).orElse(Direction.SOUTH);
        float angle = 180.0f + AngleHelper.horizontalAngle(facing);
        Vec3 sizeOffset = VecHelper.rotate(new Vec3(0.0, (double)-0.4f, (double)(0.0625f * (float)size.ordinal())), angle, Direction.Axis.Y);
        Vec3 offset = VecHelper.rotate(new Vec3(0.0, 1.0, 0.75), angle, Direction.Axis.Y);
        Vec3 v = offset.scale((double)0.45f).add(sizeOffset).add(Vec3.atCenterOf((Vec3i)pos));
        Vec3 m = offset.subtract(Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(0.75));
        world.addParticle((ParticleOptions)AllParticleTypes.STEAM_JET, v.x, v.y, v.z, m.x, m.y, m.z);
    }
}

