/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FilteringRenderer {
    public static void tick(Minecraft mc) {
        List<FilteringBehaviour<?>> behaviours;
        HitResult target = mc.hitResult;
        if (!(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.level;
        BlockPos pos = result.getBlockPos();
        BlockState state = world.getBlockState(pos);
        if (mc.player.isShiftKeyDown()) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)blockEntity;
        ItemStack mainhandItem = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (sbe instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)sbe;
            behaviours = FactoryPanelBehaviour.allBehaviours(fpbe);
        } else {
            FilteringBehaviour<Object> behaviour = sbe.getBehaviour(FilteringBehaviour.TYPE);
            if (behaviour instanceof SidedFilteringBehaviour) {
                SidedFilteringBehaviour sidedBehaviour = (SidedFilteringBehaviour)behaviour;
                behaviour = sidedBehaviour.get(result.getDirection());
            }
            if (behaviour == null) {
                return;
            }
            behaviours = List.of(behaviour);
        }
        for (FilteringBehaviour<Object> behaviour : behaviours) {
            if (!behaviour.isActive()) continue;
            if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided) {
                ((ValueBoxTransform.Sided)behaviour.slotPositioning).fromSide(result.getDirection());
            }
            if (!behaviour.slotPositioning.shouldRender(state) || !behaviour.mayInteract((Player)mc.player)) continue;
            ItemStack filter = behaviour.getFilter();
            boolean isFilterSlotted = filter.getItem() instanceof FilterItem;
            boolean showCount = behaviour.isCountVisible();
            MutableComponent label = behaviour.getLabel();
            boolean hit = behaviour.slotPositioning.testHit((LevelAccessor)world, pos, state, target.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos)));
            AABB emptyBB = new AABB(Vec3.ZERO, Vec3.ZERO);
            AABB bb = isFilterSlotted ? emptyBB.inflate((double)0.45f, (double)0.31f, (double)0.2f) : emptyBB.inflate(0.25);
            ValueBox.ItemValueBox box = new ValueBox.ItemValueBox((Component)label, bb, pos, filter, behaviour.getCountLabelForValueBox());
            box.passive(!hit || behaviour.bypassesInput(mainhandItem));
            Outliner.getInstance().showOutline(Pair.of("filter" + behaviour.netId(), pos), box.transform(behaviour.slotPositioning)).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.getDirection());
            if (!hit) continue;
            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
            tip.add(label.copy());
            tip.add(behaviour.getTip());
            if (showCount) {
                tip.add(behaviour.getAmountTip());
            }
            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
        }
    }

    @Nullable
    public static FilterRenderState getFilterRenderState(SmartBlockEntity be, BlockState blockState, ItemModelResolver itemModelManager, double distance) {
        if (be instanceof FactoryPanelBlockEntity) {
            ArrayList<SingleFilterRenderState> list = null;
            int count = 0;
            boolean check = distance != -1.0;
            for (BlockEntityBehaviour<?> behaviour : be.getAllBehaviours()) {
                if (!(behaviour instanceof FactoryPanelBehaviour)) continue;
                FactoryPanelBehaviour factoryPanelBehaviour = (FactoryPanelBehaviour)behaviour;
                if (factoryPanelBehaviour.behaviour != null && factoryPanelBehaviour.isActive()) {
                    if (check) {
                        if (FilteringRenderer.isOutOfRange(factoryPanelBehaviour, distance)) {
                            return null;
                        }
                        check = false;
                    }
                    ItemStack filter = factoryPanelBehaviour.getFilter();
                    ValueBoxTransform slotPositioning = factoryPanelBehaviour.getSlotPositioning();
                    if (!filter.isEmpty() && slotPositioning.shouldRender(blockState)) {
                        if (list == null) {
                            list = new ArrayList<SingleFilterRenderState>(4);
                        }
                        list.add(SingleFilterRenderState.create(slotPositioning, itemModelManager, filter, be.getLevel()));
                    }
                }
                if (++count != 4) continue;
                break;
            }
            return list == null ? null : new FactoryPanelRenderState(list);
        }
        FilteringBehaviour<?> behaviour = be.getBehaviour(FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return null;
        }
        if (!(be.isVirtual() || behaviour.behaviour != null && behaviour.isActive() && !FilteringRenderer.isOutOfRange(behaviour, distance))) {
            return null;
        }
        if (behaviour instanceof SidedFilteringBehaviour) {
            SidedFilteringBehaviour sidedFilteringBehaviour = (SidedFilteringBehaviour)behaviour;
            return SidedFilterRenderState.create(sidedFilteringBehaviour, blockState, itemModelManager, be.getLevel());
        }
        ItemStack filter = behaviour.getFilter();
        if (filter.isEmpty()) {
            return null;
        }
        ValueBoxTransform slotPositioning = behaviour.getSlotPositioning();
        if (slotPositioning instanceof ValueBoxTransform.Sided) {
            ValueBoxTransform.Sided sided = (ValueBoxTransform.Sided)slotPositioning;
            return SidedSingleFilterRenderState.create(sided, blockState, itemModelManager, filter, be.getLevel());
        }
        return SingleFilterRenderState.create(slotPositioning, itemModelManager, filter, be.getLevel());
    }

    private static boolean isOutOfRange(FilteringBehaviour<?> behaviour, double distance) {
        if (distance == -1.0) {
            return false;
        }
        float max = behaviour.getRenderDistance();
        return (double)(max * max) < distance;
    }

    public record SingleFilterRenderState(ValueBoxTransform slotPositioning, ItemStackRenderState state, float offset) implements FilterRenderState
    {
        public static SingleFilterRenderState create(ValueBoxTransform slotPositioning, ItemModelResolver itemModelManager, ItemStack stack, Level world) {
            ItemStackRenderState renderState = new ItemStackRenderState();
            renderState.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(renderState, stack, ItemDisplayContext.FIXED, world, null, 0);
            return new SingleFilterRenderState(slotPositioning, renderState, ValueBoxRenderer.customZOffset(stack.getItem()));
        }

        @Override
        public void render(BlockState blockState, SubmitNodeCollector queue, PoseStack ms, int light) {
            ms.pushPose();
            this.slotPositioning.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(this.state, queue, ms, light, this.offset);
            ms.popPose();
        }
    }

    public record FactoryPanelRenderState(List<SingleFilterRenderState> states) implements FilterRenderState
    {
        @Override
        public void render(BlockState blockState, SubmitNodeCollector queue, PoseStack ms, int light) {
            for (SingleFilterRenderState state : this.states) {
                state.render(blockState, queue, ms, light);
            }
        }
    }

    public record SidedFilterRenderState(ValueBoxTransform.Sided slotPositioning, Direction side, List<BoxRenderState> boxes) implements FilterRenderState
    {
        @Nullable
        public static FilterRenderState create(SidedFilteringBehaviour behaviour, BlockState blockState, ItemModelResolver itemModelManager, Level world) {
            boolean flat = blockState.is((Block)AllBlocks.CONTRAPTION_CONTROLS);
            ValueBoxTransform.Sided sided = behaviour.getSlotPositioning();
            ArrayList<BoxRenderState> boxes = new ArrayList<BoxRenderState>();
            Direction side = sided.getSide();
            for (Direction direction : Iterate.directions) {
                ItemStack filter = behaviour.getFilter(direction);
                if (filter.isEmpty()) continue;
                sided.fromSide(direction);
                if (!sided.shouldRender(blockState)) continue;
                ItemStackRenderState renderState = new ItemStackRenderState();
                if (flat) {
                    renderState.displayContext = ItemDisplayContext.GUI;
                    itemModelManager.appendItemLayers(renderState, filter, renderState.displayContext, world, null, 0);
                    boxes.add(new FlatBoxState(direction, renderState));
                    continue;
                }
                renderState.displayContext = ItemDisplayContext.FIXED;
                itemModelManager.appendItemLayers(renderState, filter, renderState.displayContext, world, null, 0);
                boxes.add(new BoxState(direction, renderState, ValueBoxRenderer.customZOffset(filter.getItem())));
            }
            sided.fromSide(side);
            return boxes.isEmpty() ? null : new SidedFilterRenderState(sided, side, boxes);
        }

        @Override
        public void render(BlockState blockState, SubmitNodeCollector queue, PoseStack ms, int light) {
            for (BoxRenderState box : this.boxes) {
                ms.pushPose();
                this.slotPositioning.fromSide(box.side());
                this.slotPositioning.transform(blockState, ms);
                box.render(queue, ms, light);
                ms.popPose();
            }
            this.slotPositioning.fromSide(this.side);
        }

        record FlatBoxState(Direction side, ItemStackRenderState state) implements BoxRenderState
        {
            @Override
            public void render(SubmitNodeCollector queue, PoseStack ms, int light) {
                ValueBoxRenderer.renderFlatItemIntoValueBox(this.state, queue, ms, light);
            }
        }

        record BoxState(Direction side, ItemStackRenderState state, float offset) implements BoxRenderState
        {
            @Override
            public void render(SubmitNodeCollector queue, PoseStack ms, int light) {
                ValueBoxRenderer.renderItemIntoValueBox(this.state, queue, ms, light, this.offset);
            }
        }

        public static interface BoxRenderState {
            public Direction side();

            public void render(SubmitNodeCollector var1, PoseStack var2, int var3);
        }
    }

    public static interface FilterRenderState {
        public void render(BlockState var1, SubmitNodeCollector var2, PoseStack var3, int var4);
    }

    public record SidedSingleFilterRenderState(ValueBoxTransform.Sided sided, Direction side, ItemStackRenderState state, Float offset, List<Direction> sides) implements FilterRenderState
    {
        public static SidedSingleFilterRenderState create(ValueBoxTransform.Sided sided, BlockState blockState, ItemModelResolver itemModelManager, ItemStack filter, Level world) {
            Float offset;
            ItemStackRenderState renderState = new ItemStackRenderState();
            if (blockState.is((Block)AllBlocks.CONTRAPTION_CONTROLS)) {
                renderState.displayContext = ItemDisplayContext.GUI;
                offset = null;
            } else {
                renderState.displayContext = ItemDisplayContext.FIXED;
                offset = Float.valueOf(ValueBoxRenderer.customZOffset(filter.getItem()));
            }
            itemModelManager.appendItemLayers(renderState, filter, renderState.displayContext, world, null, 0);
            Direction side = sided.getSide();
            ArrayList<Direction> sides = new ArrayList<Direction>();
            for (Direction direction : Iterate.directions) {
                sided.fromSide(direction);
                if (!sided.shouldRender(blockState)) continue;
                sides.add(direction);
            }
            sided.fromSide(side);
            return new SidedSingleFilterRenderState(sided, side, renderState, offset, sides);
        }

        @Override
        public void render(BlockState blockState, SubmitNodeCollector queue, PoseStack ms, int light) {
            boolean flat = this.offset == null;
            for (Direction side : this.sides) {
                ms.pushPose();
                this.sided.fromSide(side);
                this.sided.transform(blockState, ms);
                if (flat) {
                    ValueBoxRenderer.renderFlatItemIntoValueBox(this.state, queue, ms, light);
                } else {
                    ValueBoxRenderer.renderItemIntoValueBox(this.state, queue, ms, light, this.offset.floatValue());
                }
                ms.popPose();
            }
            this.sided.fromSide(this.side);
        }
    }
}

