/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.content.contraptions.DirectionalExtenderScrollOptionSlot;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.IControlContraption;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MovementModeScrollBehaviour
extends ScrollOptionBehaviour<IControlContraption.MovementMode> {
    public MovementModeScrollBehaviour(SmartBlockEntity be, Component title, ValueBoxTransform slot) {
        super(MovementModeIcon.class, MovementModeIcon::from, title, be, slot);
    }

    public static MovementModeScrollBehaviour pulley(SmartBlockEntity be) {
        return new MovementModeScrollBehaviour(be, (Component)CreateLang.translateDirect("contraptions.movement_mode", new Object[0]), (ValueBoxTransform)new CenteredSideValueBoxTransform((state, d) -> d == Direction.UP));
    }

    public static MovementModeScrollBehaviour piston(SmartBlockEntity be) {
        return new MovementModeScrollBehaviour(be, (Component)CreateLang.translateDirect("contraptions.movement_mode", new Object[0]), (ValueBoxTransform)new DirectionalExtenderScrollOptionSlot((state, d) -> {
            Direction.Axis axis = d.getAxis();
            Direction.Axis extensionAxis = ((Direction)state.getValue((Property)MechanicalPistonBlock.FACING)).getAxis();
            Direction.Axis shaftAxis = ((IRotate)state.getBlock()).getRotationAxis((BlockState)state);
            return extensionAxis != axis && shaftAxis != axis;
        }));
    }

    private static enum MovementModeIcon implements INamedIconOptions
    {
        MOVE_PLACE(AllIcons.I_MOVE_PLACE),
        MOVE_PLACE_RETURNED(AllIcons.I_MOVE_PLACE_RETURNED),
        MOVE_NEVER_PLACE(AllIcons.I_MOVE_NEVER_PLACE);

        private final String translationKey;
        private final AllIcons icon;

        private MovementModeIcon(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "create.contraptions.movement_mode." + Lang.asId(this.name());
        }

        public static MovementModeIcon from(IControlContraption.MovementMode mode) {
            return switch (mode) {
                default -> throw new MatchException(null, null);
                case IControlContraption.MovementMode.MOVE_PLACE -> MOVE_PLACE;
                case IControlContraption.MovementMode.MOVE_PLACE_RETURNED -> MOVE_PLACE_RETURNED;
                case IControlContraption.MovementMode.MOVE_NEVER_PLACE -> MOVE_NEVER_PLACE;
            };
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

